/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.attachment;

import cofh.lib.api.IConveyableData;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IAttachmentFactory;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import cofh.thermal.dynamics.attachment.RedstoneControlLogic;
import cofh.thermal.dynamics.client.TDynTextures;
import cofh.thermal.dynamics.inventory.container.attachment.EnergyLimiterAttachmentContainer;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.Optional;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyLimiterAttachment
implements IAttachment,
IRedstoneControllableAttachment,
IConveyableData,
MenuProvider {
    public static final IAttachmentFactory<IAttachment> FACTORY = (nbt, duct, side) -> new EnergyLimiterAttachment(duct, side).read(nbt);
    public static final Component DISPLAY_NAME = Component.m_237115_((String)"attachment.thermal.energy_limiter");
    public final int MAX_TRANSFER = 64000;
    protected final IDuct<?, ?> duct;
    protected final Direction side;
    public int amountInput = 32000;
    public int amountOutput = 32000;
    protected RedstoneControlLogic rsControl = new RedstoneControlLogic(this);
    protected LazyOptional<IEnergyStorage> gridCap = LazyOptional.empty();
    protected LazyOptional<IEnergyStorage> externalCap = LazyOptional.empty();

    public EnergyLimiterAttachment(IDuct<?, ?> duct, Direction side) {
        this.duct = duct;
        this.side = side;
    }

    public int getMaxTransfer() {
        return 64000;
    }

    @Override
    public IDuct<?, ?> duct() {
        return this.duct;
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public IAttachment read(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            return this;
        }
        this.rsControl.read(nbt);
        this.amountInput = nbt.m_128451_("AmountIn");
        this.amountOutput = nbt.m_128451_("AmountOut");
        return this;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("Type", "energy_limiter");
        this.rsControl.write(nbt);
        nbt.m_128405_("AmountIn", this.amountInput);
        nbt.m_128405_("AmountOut", this.amountOutput);
        return nbt;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("energy_limiter_attachment"));
    }

    @Override
    public ResourceLocation getTexture() {
        return this.rsControl.getState() ? TDynTextures.ENERGY_LIMITER_ATTACHMENT_ACTIVE_LOC : TDynTextures.ENERGY_LIMITER_ATTACHMENT_LOC;
    }

    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new EnergyLimiterAttachmentContainer(i, player.m_9236_(), this.pos(), this.side, inventory, player);
    }

    @Override
    public <T> LazyOptional<T> wrapGridCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> gridLazOpt) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            Object t;
            if (this.gridCap.isPresent()) {
                return this.gridCap.cast();
            }
            Optional gridOpt = gridLazOpt.resolve();
            if (gridOpt.isPresent() && (t = gridOpt.get()) instanceof IEnergyStorage) {
                IEnergyStorage storage = (IEnergyStorage)t;
                this.gridCap = LazyOptional.of(() -> new WrappedEnergyStorage(storage, () -> this.rsControl.getState() ? this.amountInput : 0, () -> this.rsControl.getState() ? this.amountOutput : 0));
                gridLazOpt.addListener(e -> this.gridCap.invalidate());
                return this.gridCap.cast();
            }
        }
        return gridLazOpt;
    }

    @Override
    public <T> LazyOptional<T> wrapExternalCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> extLazOpt) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            Object t;
            if (this.externalCap.isPresent()) {
                return this.externalCap.cast();
            }
            Optional extOpt = extLazOpt.resolve();
            if (extOpt.isPresent() && (t = extOpt.get()) instanceof IEnergyStorage) {
                IEnergyStorage storage = (IEnergyStorage)t;
                this.externalCap = LazyOptional.of(() -> new WrappedEnergyStorage(storage, () -> this.rsControl.getState() ? this.amountOutput : 0, () -> this.rsControl.getState() ? this.amountInput : 0));
                extLazOpt.addListener(e -> this.externalCap.invalidate());
                return this.externalCap.cast();
            }
        }
        return extLazOpt;
    }

    @Override
    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    @Override
    public void handleConfigPacket(FriendlyByteBuf buffer) {
        this.amountInput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxTransfer());
        this.amountOutput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxTransfer());
    }

    @Override
    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        this.rsControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        this.rsControl.readFromBuffer(buffer);
    }

    @Override
    public RedstoneControlLogic redstoneControl() {
        return this.rsControl;
    }

    public void readConveyableData(Player player, CompoundTag tag) {
        this.rsControl.readSettings(tag);
    }

    public void writeConveyableData(Player player, CompoundTag tag) {
        this.rsControl.writeSettings(tag);
    }

    private static class WrappedEnergyStorage
    implements IEnergyStorage {
        protected IEnergyStorage wrappedStorage;
        protected IntSupplier curReceive;
        protected IntSupplier curExtract;

        public WrappedEnergyStorage(IEnergyStorage wrappedStorage, IntSupplier curReceive, IntSupplier curExtract) {
            this.wrappedStorage = wrappedStorage;
            this.curReceive = curReceive;
            this.curExtract = curExtract;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.wrappedStorage.receiveEnergy(Math.min(maxReceive, this.curReceive.getAsInt()), simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.wrappedStorage.extractEnergy(Math.min(maxExtract, this.curExtract.getAsInt()), simulate);
        }

        public int getEnergyStored() {
            return this.wrappedStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.wrappedStorage.getEnergyStored();
        }

        public boolean canExtract() {
            return this.wrappedStorage.canExtract();
        }

        public boolean canReceive() {
            return this.wrappedStorage.canReceive();
        }
    }
}

