/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketQuickCast {
    int slot;

    public PacketQuickCast(int slot) {
        this.slot = slot;
    }

    public PacketQuickCast(FriendlyByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                InteractionHand hand = StackUtil.getQuickCaster((Player)player);
                if (hand == null) {
                    return;
                }
                ItemStack stack = player.m_21120_(hand);
                Item patt1179$temp = stack.m_41720_();
                if (!(patt1179$temp instanceof ISpellHotkeyListener)) {
                    return;
                }
                ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)patt1179$temp;
                hotkeyListener.onQuickCast(stack, player, hand, this.slot);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

