/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.FindItem;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.ForageManaBerries;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NewStoreItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NewTakeItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StarbyTransportBehavior
extends StarbyListBehavior {
    public static final ResourceLocation TRANSPORT_ID = new ResourceLocation("ars_nouveau", "starby_transport");
    public ItemStack itemScroll;

    public StarbyTransportBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (!entity.isTamed()) {
            return;
        }
        if (tag.m_128441_("itemScroll")) {
            this.itemScroll = ItemStack.m_41712_((CompoundTag)tag.m_128469_("itemScroll"));
        }
        this.goals.add(new WrappedGoal(1, (Goal)new FindItem(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(2, (Goal)new ForageManaBerries(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(3, new NewStoreItemGoal<StarbyTransportBehavior>(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(3, new NewTakeItemGoal<StarbyTransportBehavior>(this.starbuncle, this)));
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof ItemScroll) {
            ItemScroll scroll = (ItemScroll)item;
            this.itemScroll = stack.m_41777_();
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void pickUpItem(ItemEntity itemEntity) {
        super.pickUpItem(itemEntity);
        if (this.getValidStorePos(itemEntity.m_32055_()) == null || this.isPickupDisabled()) {
            return;
        }
        this.starbuncle.setHeldStack(itemEntity.m_32055_());
        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        this.level.m_6263_(null, this.getX(), this.getY(), this.getZ(), SoundEvents.f_12019_, this.starbuncle.m_5720_(), 1.0f, 1.0f);
        for (ItemEntity i : this.level.m_45976_(ItemEntity.class, this.starbuncle.m_20191_().m_82400_(3.0))) {
            if (itemEntity.m_32055_().m_41613_() >= itemEntity.m_32055_().m_41741_()) break;
            int maxTake = this.starbuncle.getHeldStack().m_41741_() - this.starbuncle.getHeldStack().m_41613_();
            if (!i.m_32055_().m_41656_(this.starbuncle.getHeldStack())) continue;
            int toTake = Math.min(i.m_32055_().m_41613_(), maxTake);
            i.m_32055_().m_41774_(toTake);
            this.starbuncle.getHeldStack().m_41769_(toTake);
        }
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        if (this.TO_LIST.isEmpty() || stack.m_41619_()) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : this.TO_LIST) {
            ItemScroll.SortPref pref = this.isValidStorePos(b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
        }
        return returnPos;
    }

    public ItemScroll.SortPref isValidStorePos(@javax.annotation.Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.m_41619_() || b == null) {
            return ItemScroll.SortPref.INVALID;
        }
        return this.canDepositItem(this.level.m_7702_(b), stack);
    }

    public boolean isPickupDisabled() {
        return this.starbuncle.getCosmeticItem().m_41720_() == ItemsRegistry.STARBUNCLE_SHADES.get();
    }

    @javax.annotation.Nullable
    public IItemHandler getItemCapFromTile(BlockEntity blockEntity) {
        Optional lazy;
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && (lazy = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isPresent()) {
            return (IItemHandler)lazy.get();
        }
        return null;
    }

    @javax.annotation.Nullable
    public BlockPos getValidTakePos() {
        if (this.FROM_LIST.isEmpty()) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidTake(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null) {
            return false;
        }
        IItemHandler iItemHandler = this.getItemCapFromTile(this.level.m_7702_(p));
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.m_41619_() || this.getValidStorePos(stack) == null) continue;
            return true;
        }
        return false;
    }

    public int getMaxTake(ItemStack stack) {
        if (this.getValidStorePos(stack) == null) {
            return -1;
        }
        BlockPos validStorePos = this.getValidStorePos(stack);
        if (validStorePos == null) {
            return -1;
        }
        IItemHandler handler = this.getItemCapFromTile(this.level.m_7702_(validStorePos));
        if (handler == null) {
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            int maxRoom;
            ItemStack handlerStack = handler.getStackInSlot(i);
            if (handlerStack.m_41619_()) {
                return handler.getSlotLimit(i);
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)handler.getStackInSlot(i), (ItemStack)stack) || (maxRoom = handlerStack.m_41741_() - handlerStack.m_41613_()) <= 0) continue;
            return Math.min(maxRoom, handler.getSlotLimit(i));
        }
        return -1;
    }

    private ItemScroll.SortPref canDepositItem(BlockEntity tile, ItemStack stack) {
        ItemScroll scrollItem;
        Item item;
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (tile == null || stack == null || stack.m_41619_()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = this.getItemCapFromTile(tile);
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrame i : this.level.m_45976_(ItemFrame.class, new AABB(tile.m_58899_()).m_82400_(1.0))) {
            BlockEntity adjTile = this.level.m_7702_(i.m_20183_().m_121945_(i.m_6350_().m_122424_()));
            if (adjTile == null || !adjTile.equals(tile) || i.m_31822_().m_41619_()) continue;
            ItemStack stackInFrame = i.m_31822_();
            Item item2 = stackInFrame.m_41720_();
            if (item2 instanceof ItemScroll) {
                ItemScroll scrollItem2 = (ItemScroll)item2;
                pref = scrollItem2.getSortPref(stack, stackInFrame, handler);
                continue;
            }
            if (i.m_31822_().m_41720_() != stack.m_41720_()) {
                return ItemScroll.SortPref.INVALID;
            }
            if (i.m_31822_().m_41720_() != stack.m_41720_()) continue;
            pref = ItemScroll.SortPref.HIGHEST;
        }
        if (this.itemScroll != null && (item = this.itemScroll.m_41720_()) instanceof ItemScroll && (scrollItem = (ItemScroll)item).getSortPref(stack, this.itemScroll, handler) == ItemScroll.SortPref.INVALID) {
            return ItemScroll.SortPref.INVALID;
        }
        return !ItemStack.m_41728_((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    @Override
    public boolean canGoToBed() {
        return this.getValidTakePos() == null && (this.starbuncle.getHeldStack().m_41619_() || this.getValidStorePos(this.starbuncle.getHeldStack()) == null);
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, storedEntity, playerEntity);
        if (storedPos == null) {
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(storedPos);
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.store"));
            this.addToPos(storedPos);
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedPos == null) {
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(storedPos);
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.take"));
            this.addFromPos(storedPos);
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.itemScroll = ItemStack.f_41583_;
        super.onWanded(playerEntity);
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        super.toTag(tag);
        if (this.itemScroll != null) {
            tag.m_128365_("itemScroll", (Tag)this.itemScroll.serializeNBT());
        }
        return tag;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.storing", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.taking", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (this.itemScroll != null && !this.itemScroll.m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.itemScroll.m_41786_().getString()}));
        }
    }

    @Override
    protected ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }
}

