/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network;

import com.hrznstudio.titanium.api.block_network.NetworkElement;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.NetworkRegistry;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends SavedData {
    private static final String NAME = "titanium_block_networks";
    private static final Logger LOGGER = LogManager.getLogger(NetworkManager.class);
    private final Level level;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private final Map<BlockPos, NetworkElement> elements = new HashMap<BlockPos, NetworkElement>();

    public NetworkManager(Level level) {
        this.level = level;
    }

    public static NetworkManager get(Level level) {
        return NetworkManager.get((ServerLevel)level);
    }

    public static NetworkManager get(ServerLevel level) {
        return (NetworkManager)level.m_8895_().m_164861_(tag -> {
            NetworkManager networkManager = new NetworkManager((Level)level);
            networkManager.load((CompoundTag)tag);
            return networkManager;
        }, () -> new NetworkManager((Level)level), NAME);
    }

    public void addNetwork(Network network) {
        if (this.networks.containsKey(network.getId())) {
            throw new RuntimeException("Duplicate network " + network.getId());
        }
        this.networks.put(network.getId(), network);
        LOGGER.debug("Network {} created", (Object)network.getId());
        this.m_77762_();
    }

    public void removeNetwork(String id) {
        if (!this.networks.containsKey(id)) {
            throw new RuntimeException("Network " + id + " not found");
        }
        this.networks.remove(id);
        LOGGER.debug("Network {} removed", (Object)id);
        this.m_77762_();
    }

    private void formNetworkAt(Level level, BlockPos pos, ResourceLocation type) {
        Network network = NetworkRegistry.INSTANCE.getFactory(type).create(pos);
        this.addNetwork(network);
        network.scanGraph(level, pos);
    }

    private void mergeNetworksIntoOne(Set<NetworkElement> candidates, Level level, BlockPos pos) {
        if (candidates.isEmpty()) {
            throw new RuntimeException("Cannot merge networks: no candidates");
        }
        HashSet<Network> networkCandidates = new HashSet<Network>();
        for (NetworkElement candidate : candidates) {
            if (candidate.getNetwork() == null) {
                throw new RuntimeException("Element network is null!");
            }
            networkCandidates.add(candidate.getNetwork());
        }
        Iterator networks = networkCandidates.iterator();
        Network mainNetwork = (Network)networks.next();
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        while (networks.hasNext()) {
            Network otherNetwork = (Network)networks.next();
            boolean canMerge = mainNetwork.getType().equals((Object)otherNetwork.getType());
            if (!canMerge) continue;
            mergedNetworks.add(otherNetwork);
            this.removeNetwork(otherNetwork.getId());
        }
        mainNetwork.scanGraph(level, pos);
        mergedNetworks.forEach(n -> n.onMergedWith(mainNetwork));
    }

    public void addElement(NetworkElement matterNetworkElement) {
        if (this.elements.containsKey(matterNetworkElement.getPos())) {
            throw new RuntimeException("Network element at " + matterNetworkElement.getPos() + " already exists");
        }
        this.elements.put(matterNetworkElement.getPos(), matterNetworkElement);
        LOGGER.debug("Network element added at {}", (Object)matterNetworkElement.getPos());
        this.m_77762_();
        Set<NetworkElement> adjacentElement = this.findAdjacentElements(matterNetworkElement.getPos(), matterNetworkElement.getNetworkType());
        if (adjacentElement.isEmpty()) {
            this.formNetworkAt(matterNetworkElement.getLevel(), matterNetworkElement.getPos(), matterNetworkElement.getNetworkType());
        } else {
            this.mergeNetworksIntoOne(adjacentElement, matterNetworkElement.getLevel(), matterNetworkElement.getPos());
        }
    }

    public void removeElement(BlockPos pos) {
        NetworkElement element = this.getElement(pos);
        if (element == null) {
            throw new RuntimeException("Element at " + pos + " was not found");
        }
        if (element.getNetwork() == null) {
            LOGGER.warn("Removed element at {} has no associated network", (Object)element.getPos());
        }
        this.elements.remove(element.getPos());
        LOGGER.debug("Element removed at {}", (Object)element.getPos());
        this.m_77762_();
        if (element.getNetwork() != null) {
            this.splitNetworks(element);
        }
    }

    private void splitNetworks(NetworkElement originElement) {
        for (NetworkElement adjacent : this.findAdjacentElements(originElement.getPos(), originElement.getNetworkType())) {
            if (adjacent.getNetwork() == null) {
                throw new RuntimeException("Adjacent element has no network");
            }
            if (adjacent.getNetwork() == originElement.getNetwork()) continue;
            throw new RuntimeException("The origin element network is different than the adjacent element network");
        }
        NetworkElement otherElementInNetwork = this.findFirstAdjacentElement(originElement.getPos(), originElement.getNetworkType());
        if (otherElementInNetwork != null) {
            otherElementInNetwork.getNetwork().setOriginPos(otherElementInNetwork.getPos());
            this.m_77762_();
            NetworkGraphScannerResult result = otherElementInNetwork.getNetwork().scanGraph(otherElementInNetwork.getLevel(), otherElementInNetwork.getPos());
            boolean foundRemovedElement = false;
            for (NetworkElement removed : result.getRemovedElements()) {
                if (removed.getPos().equals((Object)originElement.getPos())) {
                    foundRemovedElement = true;
                    continue;
                }
                if (removed.getNetwork() != null) continue;
                this.formNetworkAt(removed.getLevel(), removed.getPos(), removed.getNetworkType());
            }
            if (!foundRemovedElement) {
                throw new RuntimeException("Didn't find removed element when splitting network");
            }
        } else {
            LOGGER.debug("Removing empty network {}", (Object)originElement.getNetwork().getId());
            this.removeNetwork(originElement.getNetwork().getId());
        }
    }

    private Set<NetworkElement> findAdjacentElements(BlockPos pos, ResourceLocation networkType) {
        HashSet<NetworkElement> elements = new HashSet<NetworkElement>();
        for (Direction dir : Direction.values()) {
            NetworkElement element = this.getElement(pos.m_121945_(dir));
            if (element == null || !element.getNetworkType().equals((Object)networkType)) continue;
            elements.add(element);
        }
        return elements;
    }

    @Nullable
    private NetworkElement findFirstAdjacentElement(BlockPos pos, ResourceLocation networkType) {
        for (Direction dir : Direction.values()) {
            NetworkElement element = this.getElement(pos.m_121945_(dir));
            if (element == null || !element.getNetworkType().equals((Object)networkType)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public NetworkElement getElement(BlockPos pos) {
        return this.elements.get(pos);
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public void load(CompoundTag tag) {
        ListTag elements = tag.m_128437_("elements", 10);
        for (Tag elementTag : elements) {
            CompoundTag elementTagCompound = (CompoundTag)elementTag;
            ResourceLocation factoryId = new ResourceLocation(elementTagCompound.m_128461_("id"));
            NetworkElementFactory factory = NetworkElementRegistry.INSTANCE.getFactory(factoryId);
            if (factory == null) {
                LOGGER.warn("Element {} no longer exists", (Object)factoryId.toString());
                continue;
            }
            NetworkElement element = factory.createFromNbt(this.level, elementTagCompound);
            this.elements.put(element.getPos(), element);
        }
        ListTag nets = tag.m_128437_("networks", 10);
        for (Tag netTag : nets) {
            CompoundTag netTagCompound = (CompoundTag)netTag;
            if (!netTagCompound.m_128441_("type")) {
                LOGGER.warn("Skipping network without type");
                continue;
            }
            ResourceLocation type = new ResourceLocation(netTagCompound.m_128461_("type"));
            NetworkFactory factory = NetworkRegistry.INSTANCE.getFactory(type);
            if (factory == null) {
                LOGGER.warn("Unknown network type {}", (Object)type.toString());
                continue;
            }
            Network network = factory.create(netTagCompound);
            this.networks.put(network.getId(), network);
        }
        LOGGER.debug("Read {} elements", (Object)elements.size());
        LOGGER.debug("Read {} networks", (Object)this.networks.size());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag elements = new ListTag();
        this.elements.values().forEach(p -> {
            CompoundTag elementTag = new CompoundTag();
            elementTag.m_128359_("id", p.getId().toString());
            elements.add((Object)p.writeToNbt(elementTag));
        });
        tag.m_128365_("elements", (Tag)elements);
        ListTag networks = new ListTag();
        this.networks.values().forEach(n -> {
            CompoundTag networkTag = new CompoundTag();
            networkTag.m_128359_("type", n.getType().toString());
            networks.add((Object)n.writeToNbt(networkTag));
        });
        tag.m_128365_("networks", (Tag)networks);
        return tag;
    }
}

