/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.event.AvailableSpellTreesEvent;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.requirement.WrappedRequirement;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ProgressionHelper {
    public static List<SpellTree> stripSpellTrees(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access, List<SpellTree> allAvailableSkillTrees) {
        LinkedList<SpellTree> strippedSkillTrees = new LinkedList<SpellTree>();
        for (SpellTree spellTree0 : allAvailableSkillTrees) {
            if (spellTree0.getRoot() == null || !spellTree0.canSee(spellProgressionHolder, access)) continue;
            SpellTree stripped = spellTree0.copy();
            LinkedList<SpellNode> visibleNodes = new LinkedList<SpellNode>();
            stripped.forEach(spellNode -> {
                if (spellProgressionHolder.getSpellStatus(spellNode.getSpell()).isVisible()) {
                    visibleNodes.add((SpellNode)spellNode);
                }
            });
            if (!visibleNodes.contains(stripped.getRoot())) {
                visibleNodes.add(stripped.getRoot());
                if (visibleNodes.size() == 1) {
                    stripped.getRoot().getChildren().clear();
                    strippedSkillTrees.add(stripped);
                    continue;
                }
            }
            for (SpellNode spellNode2 : visibleNodes.stream().toList()) {
                SpellNode parent;
                while ((parent = spellNode2.getParent()) != null && !visibleNodes.contains(parent)) {
                    visibleNodes.add(parent);
                    spellNode2 = parent;
                }
            }
            LinkedList invisibleNodes = new LinkedList();
            stripped.forEach(spellNode -> {
                if (!visibleNodes.contains(spellNode)) {
                    boolean fullyLinked = ProgressionHelper.isFullyLinked(spellNode, spellProgressionHolder.getProgression());
                    if (fullyLinked) {
                        spellNode.getChildren().clear();
                    } else {
                        invisibleNodes.add(spellNode);
                    }
                }
            });
            invisibleNodes.forEach(spellNode -> spellNode.getParent().getChildren().remove(spellNode));
            strippedSkillTrees.add(stripped);
        }
        strippedSkillTrees.forEach(tree -> {
            tree.forEach(node -> node.setRequirements(node.getRequirements().stream().map(r -> WrappedRequirement.wrap(r, spellProgressionHolder, access)).collect(Collectors.toList())));
            tree.setRequirements(tree.getRequirements().stream().map(r -> WrappedRequirement.wrap(r, spellProgressionHolder, access)).collect(Collectors.toList()));
        });
        return strippedSkillTrees;
    }

    public static List<SpellTree> getStrippedSpellTrees(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        List<SpellTree> allAvailableSkillTrees = ProgressionHelper.getAllAvailableSpellTrees(spellProgressionHolder, access);
        List<SpellTree> availableSpellTrees = ProgressionHelper.stripSpellTrees(spellProgressionHolder, access, allAvailableSkillTrees);
        availableSpellTrees.forEach(SpellTree::assignNodeIds);
        return availableSpellTrees;
    }

    public static List<SpellTree> getAllAvailableSpellTrees(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess containerLevelAccess) {
        LinkedList<SpellTree> availableSpellTrees = new LinkedList<SpellTree>();
        AvailableSpellTreesEvent event = new AvailableSpellTreesEvent(spellProgressionHolder.getPlayer(), spellProgressionHolder, availableSpellTrees);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return availableSpellTrees;
    }

    public static boolean isFullyLinked(SpellNode spellNode, Map<ISpell, SpellStatus> progression) {
        SpellNode parent = spellNode;
        while ((parent = parent.getParent()) != null) {
            if (progression.getOrDefault(parent.getSpell(), SpellStatus.LOCKED).isAvailable()) continue;
            return false;
        }
        return true;
    }

    public static boolean tryBuySpell(SpellProgressionHolder spellProgressionHolder, SpellProgressionMenu menu, int id, ISpell spell, UUID uuid) {
        Player player = menu.player;
        AtomicBoolean found = new AtomicBoolean(false);
        menu.spellTrees.stream().filter(tree -> tree.getId().equals(uuid)).findFirst().ifPresent(spellTree -> {
            SpellNode spellNode = spellTree.findNode(id);
            if (spellNode.getSpell() == spell && spellNode.canLearn(spellProgressionHolder, menu.access)) {
                found.set(true);
                if (!player.m_7500_()) {
                    player.m_6749_(-spellNode.getLevelCost());
                }
                spellNode.onSpellLearned(spellProgressionHolder, menu.access);
            }
        });
        return found.get();
    }
}

