/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.ISpell;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class SpellNode {
    protected final ISpell spell;
    protected int levelCost;
    protected List<Requirement> requirements;
    protected SpellNode parent;
    protected LinkedList<SpellNode> children;
    protected int id;

    public SpellNode(ISpell spell, int levelCost, List<Requirement> requirements, int id) {
        this.spell = spell;
        this.levelCost = Math.max(0, levelCost);
        this.requirements = requirements;
        this.children = new LinkedList();
        this.id = id;
    }

    public SpellNode(ISpell spell, int levelCost, List<Requirement> requirements) {
        this(spell, levelCost, requirements, -1);
    }

    public ISpell getSpell() {
        return this.spell;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public void setLevelCost(int levelCost) {
        this.levelCost = levelCost;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.requirements.stream().allMatch(requirement -> requirement.passes(spellProgressionHolder, access));
    }

    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        this.requirements.forEach(requirement -> requirement.onSpellLearned(spellProgressionHolder, access));
    }

    public boolean canLearn(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return spellProgressionHolder.getPlayer().m_7500_() || spellProgressionHolder.getPlayer().f_36078_ >= this.levelCost && this.passes(spellProgressionHolder, access);
    }

    public List<Component> getTooltip(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        LinkedList<Component> tooltips = new LinkedList<Component>();
        tooltips.add((Component)this.spell.getSpellName());
        this.requirements.forEach(requirement -> tooltips.add((Component)requirement.makeDescription(spellProgressionHolder, access)));
        return tooltips;
    }

    public void setParent(@Nullable SpellNode parent) {
        this.parent = parent;
    }

    public void addChild(SpellNode child) {
        this.children.add(child);
    }

    public SpellNode copy() {
        return new SpellNode(this.spell, this.levelCost, this.requirements);
    }

    @Nullable
    public SpellNode getParent() {
        return this.parent;
    }

    public LinkedList<SpellNode> getChildren() {
        return this.children;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

