/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LightningStrikeSpell
extends BaseIngredientsSpell {
    public final int defaultRange;
    protected int range;

    public LightningStrikeSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int range) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultRange = range;
    }

    public LightningStrikeSpell(float manaCost, ItemStack handIngredient, int range) {
        super(manaCost, handIngredient);
        this.defaultRange = range;
    }

    public LightningStrikeSpell(float manaCost, int range) {
        super(manaCost);
        this.defaultRange = range;
    }

    public LightningStrikeSpell() {
        this(8.0f, new ItemStack((ItemLike)Items.f_151052_), 20);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        Level level = manaHolder.getPlayer().f_19853_;
        LivingEntity entity = manaHolder.getPlayer();
        HitResult hit = SpellsUtil.rayTrace(level, (Entity)entity, this.range, e -> true, 0.5f, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        Vec3 oldPos = entity.m_20182_();
        if (hit.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = null;
            BlockPos blockPos = null;
            if (hit.m_6662_() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                pos = blockHit.m_82450_();
                blockPos = blockHit.m_82425_().m_121955_(blockHit.m_82434_().m_122436_());
            } else if (hit.m_6662_() == HitResult.Type.ENTITY && hit instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)hit;
                pos = entityHit.m_82443_().m_20182_();
                blockPos = entityHit.m_82443_().m_20183_();
            }
            if (pos != null && level.m_45527_(blockPos)) {
                LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, level);
                lightningBolt.m_20219_(pos);
                level.m_7967_((Entity)lightningBolt);
            }
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("range", (Number)this.defaultRange);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.range = SpellsFileUtil.jsonInt(json, "range");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.range = this.defaultRange;
    }
}

