/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.client.SpellKeyBindings;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.ISpell;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;

public class LangGen
extends LanguageProvider {
    public static final String PERMANENT_EFFECT_NAME = "%s";
    public static final String PERMANENT_EFFECT_DESC = "Applies the %s effect while this spell is equipped.";
    public static final String TEMPORARY_EFFECT_NAME = "%s";
    public static final String TEMPORARY_EFFECT_DESC = "Applies the %s effect for a short period of time.";

    public LangGen(DataGenerator dataGen, String locale) {
        super(dataGen, "spells_and_shields", locale);
    }

    protected void addTranslations() {
        this.addAttribute((Supplier<? extends Attribute>)SpellsRegistries.MAX_MANA_ATTRIBUTE, "Max Mana");
        this.addAttribute((Supplier<? extends Attribute>)SpellsRegistries.MANA_REGENERATION_ATTRIBUTE, "Mana Regeneration");
        this.add("enchantment.spells_and_shields.type." + SpellsRegistries.SHIELD_ENCHANTMENT_CATEGORY.name().toLowerCase(), "shields");
        this.add("enchantment.spells_and_shields.type." + SpellsRegistries.SWORD_OR_AXE_ENCHANTMENT_CATEGORY.name().toLowerCase(), "axes, swords");
        this.addEnchantment((Supplier<? extends Enchantment>)SpellsRegistries.MAGIC_PROTECTION_ENCHANTMENT, "Magic Protection", "Reduces magic damage.");
        this.addEnchantment((Supplier<? extends Enchantment>)SpellsRegistries.MANA_BLADE_ENCHANTMENT, "Mana Blade", "Consumes mana to increase damage.");
        this.addEnchantment((Supplier<? extends Enchantment>)SpellsRegistries.MANA_SHIELD_ENCHANTMENT, "Mana Shield", "WIP");
        this.addEnchantment((Supplier<? extends Enchantment>)SpellsRegistries.MAX_MANA_ENCHANTMENT, "Maximum Mana", "Increases your maximum mana while worn. More potent on chestplates and leggings than helmets and boots.");
        this.addEnchantment((Supplier<? extends Enchantment>)SpellsRegistries.MANA_REGENERATION_ENCHANTMENT, "Mana Regeneration", "Increases your mana regeneration while worn. More potent on chestplates and leggings than helmets and boots.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.INSTANT_MANA_EFFECT, "Instant Mana", "Replenishes mana; higher levels increase the effect potency.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.MANA_BOMB_EFFECT, "Mana Bomb", "Burns mana; higher levels increase the effect potency.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.REPLENISHMENT_EFFECT, "Replenishment", "Replenishes mana over time; higher levels make mana be replenished quicker.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.LEAKING_MOB_EFFECT, "Leaking", "Burns mana over time; higher levels burn more mana.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.MANA_BOOST_EFFECT, "Mana Boost", "Increases maximum mana; higher levels give more additional mana bottles.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.EXTRA_MANA_EFFECT, "Extra Mana", "Adds burnable mana bottles (which can't be replenished); higher levels give more extra mana.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.SILENCE_EFFECT, "Silence", "No spells can be used while this effect is active.");
        this.addEffect((Supplier<? extends MobEffect>)SpellsRegistries.MAGIC_IMMUNE_EFFECT, "Magic Immune", "Makes you ignore any magic damage.");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LONG_LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_LEAKING, "Leaking");
        this.add("key.spells_and_shields.categories.spell_slots", "Spells & Shields");
        for (int i = 0; i < 5; ++i) {
            this.add(SpellKeyBindings.key(i), "Spell Slot " + (i + 1));
        }
        this.addSpell((Supplier<? extends ISpell>)Spells.FIRE_BALL, "Fire Ball", "Shoot a fire ball forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.LEAP, "Leap", "Leap forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.SUMMON_ANIMAL, "Summon Animal", "Create life based on the item in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.BLOW_ARROW, "Blow Arrow", "Shoot a projectile from your hand without a bow.");
        this.addSpell((Supplier<? extends ISpell>)Spells.BLAST_SMELT, "Blast Smelt", "Works like an instant blast furnace on the item in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.HEALTH_BOOST, "Health Boost", "Increases your maximum health.");
        this.addSpell((Supplier<? extends ISpell>)Spells.MANA_BOOST, "Mana Boost", "Increases your maximum mana.");
        this.addSpell((Supplier<? extends ISpell>)Spells.WATER_LEAP, "Water Leap", "Leap forward like a dolphin (must be underwater).");
        this.addSpell((Supplier<? extends ISpell>)Spells.AQUA_AFFINITY, "Aqua Affinity", "Mine underwater with full speed.");
        this.addSpell((Supplier<? extends ISpell>)Spells.WATER_WHIP, "Water Whip", "Shoots water out of the water bucket in your hand. The water returns and the bucket refills if you hold it on return.");
        this.addSpell((Supplier<? extends ISpell>)Spells.POTION_SHOT, "Potion Shot", "Shots the contents of the potion in your hand forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FROST_WALKER, "Frost Walker", "Walk on water by turning the blocks you walk on into ice.");
        this.addSpell((Supplier<? extends ISpell>)Spells.JUMP, "Jump", "High jump. Be aware of fall damage.");
        this.addSpell((Supplier<? extends ISpell>)Spells.MANA_SOLES, "Mana Soles", "Consumes mana to reduce or cancel fall damage.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FIRE_CHARGE, "Fire Charge", "Shoot a fire charge forward instantly.");
        this.addSpell((Supplier<? extends ISpell>)Spells.PRESSURIZE, "Pressurize", "Knock back every entity around you and remove any fluid.");
        this.addSpell((Supplier<? extends ISpell>)Spells.INSTANT_MINE, "Instant Mine", "Breaks the block you are looking at using the tool in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.SPIT_METAL, "Spit Metal", "Spit a nugget that deals damage (from your hand).");
        this.addSpell((Supplier<? extends ISpell>)Spells.FLAMETHROWER, "Flamethrower", "Breath flames from your mouth setting everything on fire.");
        this.addSpell((Supplier<? extends ISpell>)Spells.LAVA_WALKER, "Lava Walker", "Walk on lava by turning the blocks you walk on into obsidian.");
        this.addSpell((Supplier<? extends ISpell>)Spells.SILENCE_TARGET, "Silence Target", "Silence the target you are looking at within a certain range.");
        this.addSpell((Supplier<? extends ISpell>)Spells.RANDOM_TELEPORT, "Random Teleport", "Randomly teleport away. This spell can fail.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FORCED_TELEPORT, "Forced Teleport", "Randomly teleports the target you are looking at away. This spell can fail.");
        this.addSpell((Supplier<? extends ISpell>)Spells.TELEPORT, "Teleport", "Teleport to where you are looking at.");
        this.addSpell((Supplier<? extends ISpell>)Spells.LIGHTNING_STRIKE, "Lightning Strike", "Summon a lightning strike where you are looking at. The target must see skylight.");
        this.addSpell((Supplier<? extends ISpell>)Spells.DRAIN_FLAME, "Drain Flame", "Drain fire to convert it into mana regeneration. The fire must be infinite (eg. on top of Netherrack) for this to work.");
        this.addSpell((Supplier<? extends ISpell>)Spells.GROWTH, "Growth", "Apply the effect of Bonemeal to plants around you.");
        this.addSpell((Supplier<? extends ISpell>)Spells.GHAST, "Ghast", "Shoot a fire charge forward, like a Ghast.");
        this.addSpell((Supplier<? extends ISpell>)Spells.ENDER_ARMY, "Ender Army", "Make all Endermen close to the target you are looking at attack said target.");
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_REPLENISHMENT, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_REPLENISHMENT, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_SPEED, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_JUMP_BOOST, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_DOLPHINS_GRACE, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_WATER_BREATHING, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_SLOW_FALLING, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_HASTE, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_REGENERATION, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_FIRE_RESISTANCE, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_NIGHT_VISION, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_STRENGTH, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_RESISTANCE, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_INVISIBILITY, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_GLOWING, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_LUCK, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_CONDUIT_POWER, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.PERMANENT_MAGIC_IMMUNE, "%s", PERMANENT_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_SPEED, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_JUMP_BOOST, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_DOLPHINS_GRACE, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_WATER_BREATHING, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_SLOW_FALLING, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_HASTE, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_REGENERATION, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_FIRE_RESISTANCE, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_NIGHT_VISION, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_STRENGTH, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_RESISTANCE, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_INVISIBILITY, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_GLOWING, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_LUCK, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_CONDUIT_POWER, "%s", TEMPORARY_EFFECT_DESC);
        this.addSpell((Supplier<? extends ISpell>)Spells.TEMPORARY_MAGIC_IMMUNE, "%s", TEMPORARY_EFFECT_DESC);
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.BOOKSHELVES_REQUIREMENT, "%s/%s Bookshelves");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ADVANCEMENT_REQUIREMENT, "Advancement: %s");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ADVANCEMENT_REQUIREMENT, ".error", "Unknown Advancement (config error): %s");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ITEM_REQUIREMENT, "%s (Not Consumed)");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ITEM_REQUIREMENT, ".consumed", "%s (Consumed)");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ITEM_REQUIREMENT, ".multiple", "%sx %s (Not Consumed)");
        this.addRequirement((Supplier<? extends IRequirementType<?>>)SpellsRegistries.ITEM_REQUIREMENT, ".consumed.multiple", "%sx %s (Consumed)");
        this.add("spell_tree.spells_and_shields.nether", "Nether");
        this.add("spell_tree.spells_and_shields.ocean", "Ocean");
        this.add("spell_tree.spells_and_shields.mining", "Mining");
        this.add("spell_tree.spells_and_shields.movement", "Movement");
        this.add("spell_tree.spells_and_shields.end", "End");
        this.add(SpellProgressionMenu.TITLE.getString(), "Spell Progression");
        this.add("spells.progression.learn.success.single", "%s has been learned by %s");
        this.add("spells.progression.learn.success.multiple", "%s has been learned by %s players");
        this.add("spells.progression.learn_all.success.single", "%s spells have been learned by %s");
        this.add("spells.progression.learn_all.failed.single", "%s already learned all spells");
        this.add("spells.progression.learn_all.success.multiple", "All %s habe been learned by %s players");
        this.add("spells.progression.forget.success.single", "%s has been forgotten by %s");
        this.add("spells.progression.forget.success.multiple", "%s has been forgotten by %s players");
        this.add("spells.progression.forget_all.success.single", "%s spells have been forgotten by %s");
        this.add("spells.progression.forget_all.failed.single", "%s has never learned a single spell");
        this.add("spells.progression.forget_all.success.multiple", "All %s spells have been forgotten by %s players");
        this.add("spells.progression.reset.success.single", "Cleared all learned spells of %s");
        this.add("spells.progression.reset.success.multiple", "Cleared all learned spells of %s players");
        this.add("spells.slot.remove.success.single", "Cleared active spell in slot %s of %s");
        this.add("spells.slot.remove.success.multiple", "Cleared active spell in slot %s of %s players");
        this.add("spells.slot.set.success.single", "Set active spell in slot %s of %s to %s");
        this.add("spells.slot.set.success.multiple", "Set active spell in slot %s of %s players to %s");
        this.add("spells.slot.clear.success.single", "Cleared active spells of %s");
        this.add("spells.slot.clear.success.multiple", "Cleared active spells of %s players");
        this.add("spell.ingredients.hand", "Requirement (Hand):");
        this.add("spell.ingredients.inventory", "Requirement (Inventory):");
        this.add("spell.ingredients.ingredient", "%s");
        this.add("spell.ingredients.ingredient.multiple", "%sx %s");
        this.add("spell.passive.when_applied", "When Applied:");
        this.add("spell_progression.learn", "Learn");
        this.add("spell_progression.equip", "Equip");
        this.add("spell_progression.unavailable", "Unavailable");
        this.add("spell_progression.choose", "Choose a Slot");
    }

    public void addAttribute(Supplier<? extends Attribute> key, String name) {
        this.add(key.get().m_22087_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name, String desc) {
        super.addEnchantment(key, name);
        this.add(key.get().m_44704_() + ".desc", desc);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name, String desc) {
        super.addEffect(key, name);
        this.add(key.get().m_19481_() + ".description", desc);
    }

    public void addPotion(Supplier<? extends Potion> key, String name) {
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)key.get()), "Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)key.get()), "Splash Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)key.get()), "Lingering Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)key.get()), "Arrow of " + name);
    }

    public void addSpell(Supplier<? extends ISpell> key, String name, String desc) {
        this.add(key.get().getNameKey(), name);
        this.add(key.get().getDescKey(), desc);
    }

    public void addRequirement(Supplier<? extends IRequirementType<?>> requirement, String desc) {
        this.addRequirement(requirement, "", desc);
    }

    public void addRequirement(Supplier<? extends IRequirementType<?>> requirement, String suffix, String desc) {
        Object inst = requirement.get().makeInstance();
        String descriptionId = ((Requirement)inst).getDescriptionId();
        this.add(descriptionId + suffix, desc);
    }

    public String m_6055_() {
        return "Spells & Shields Lang File";
    }
}

