/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells;

import com.google.gson.JsonElement;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.spell.IConfigurableSpell;
import de.cas_ual_ty.spells.spell.IEventSpell;
import de.cas_ual_ty.spells.spell.ISingletonTickSpell;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spell.IStackedTickSpell;
import de.cas_ual_ty.spells.spell.ITickSpell;
import de.cas_ual_ty.spells.spell.base.AttributeSpell;
import de.cas_ual_ty.spells.spell.base.PermanentMobEffectSpell;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spell.base.TemporaryMobEffectSpell;
import de.cas_ual_ty.spells.spell.impl.AquaAffinitySpell;
import de.cas_ual_ty.spells.spell.impl.BlowArrowSpell;
import de.cas_ual_ty.spells.spell.impl.DrainFlameSpell;
import de.cas_ual_ty.spells.spell.impl.EnderArmySpell;
import de.cas_ual_ty.spells.spell.impl.FireBallSpell;
import de.cas_ual_ty.spells.spell.impl.FireChargeSpell;
import de.cas_ual_ty.spells.spell.impl.FlamethrowerSpell;
import de.cas_ual_ty.spells.spell.impl.ForcedTeleportSpell;
import de.cas_ual_ty.spells.spell.impl.GhastSpell;
import de.cas_ual_ty.spells.spell.impl.GrowthSpell;
import de.cas_ual_ty.spells.spell.impl.InstantMineSpell;
import de.cas_ual_ty.spells.spell.impl.JumpSpell;
import de.cas_ual_ty.spells.spell.impl.LeapSpell;
import de.cas_ual_ty.spells.spell.impl.LightningStrikeSpell;
import de.cas_ual_ty.spells.spell.impl.ManaSolesSpell;
import de.cas_ual_ty.spells.spell.impl.PotionShotSpell;
import de.cas_ual_ty.spells.spell.impl.PressurizeSpell;
import de.cas_ual_ty.spells.spell.impl.RandomTeleportSpell;
import de.cas_ual_ty.spells.spell.impl.SilenceTargetSpell;
import de.cas_ual_ty.spells.spell.impl.SmeltSpell;
import de.cas_ual_ty.spells.spell.impl.SpitMetalSpell;
import de.cas_ual_ty.spells.spell.impl.SummonAnimalSpell;
import de.cas_ual_ty.spells.spell.impl.TeleportSpell;
import de.cas_ual_ty.spells.spell.impl.TransferManaSpell;
import de.cas_ual_ty.spells.spell.impl.WalkerSpell;
import de.cas_ual_ty.spells.spell.impl.WaterLeapSpell;
import de.cas_ual_ty.spells.spell.impl.WaterWhipSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Spells {
    public static Supplier<IForgeRegistry<ISpell>> SPELLS_REGISTRY;
    private static final DeferredRegister<ISpell> SPELLS;
    public static final RegistryObject<ISpell> LEAP;
    public static final RegistryObject<ISpell> SUMMON_ANIMAL;
    public static final RegistryObject<ISpell> FIRE_BALL;
    public static final RegistryObject<ISpell> BLAST_SMELT;
    public static final RegistryObject<ISpell> TRANSFER_MANA;
    public static final RegistryObject<ISpell> BLOW_ARROW;
    public static final RegistryObject<ISpell> HEALTH_BOOST;
    public static final RegistryObject<ISpell> MANA_BOOST;
    public static final RegistryObject<ISpell> WATER_LEAP;
    public static final RegistryObject<ISpell> AQUA_AFFINITY;
    public static final RegistryObject<ISpell> WATER_WHIP;
    public static final RegistryObject<ISpell> POTION_SHOT;
    public static final RegistryObject<ISpell> FROST_WALKER;
    public static final RegistryObject<ISpell> JUMP;
    public static final RegistryObject<ISpell> MANA_SOLES;
    public static final RegistryObject<ISpell> FIRE_CHARGE;
    public static final RegistryObject<ISpell> PRESSURIZE;
    public static final RegistryObject<ISpell> INSTANT_MINE;
    public static final RegistryObject<ISpell> SPIT_METAL;
    public static final RegistryObject<ISpell> FLAMETHROWER;
    public static final RegistryObject<ISpell> LAVA_WALKER;
    public static final RegistryObject<ISpell> SILENCE_TARGET;
    public static final RegistryObject<ISpell> RANDOM_TELEPORT;
    public static final RegistryObject<ISpell> FORCED_TELEPORT;
    public static final RegistryObject<ISpell> TELEPORT;
    public static final RegistryObject<ISpell> LIGHTNING_STRIKE;
    public static final RegistryObject<ISpell> DRAIN_FLAME;
    public static final RegistryObject<ISpell> GROWTH;
    public static final RegistryObject<ISpell> GHAST;
    public static final RegistryObject<ISpell> ENDER_ARMY;
    public static final RegistryObject<ISpell> PERMANENT_REPLENISHMENT;
    public static final RegistryObject<ISpell> TEMPORARY_REPLENISHMENT;
    public static final RegistryObject<ISpell> PERMANENT_SPEED;
    public static final RegistryObject<ISpell> PERMANENT_JUMP_BOOST;
    public static final RegistryObject<ISpell> PERMANENT_DOLPHINS_GRACE;
    public static final RegistryObject<ISpell> PERMANENT_WATER_BREATHING;
    public static final RegistryObject<ISpell> PERMANENT_SLOW_FALLING;
    public static final RegistryObject<ISpell> PERMANENT_HASTE;
    public static final RegistryObject<ISpell> PERMANENT_REGENERATION;
    public static final RegistryObject<ISpell> PERMANENT_FIRE_RESISTANCE;
    public static final RegistryObject<ISpell> PERMANENT_NIGHT_VISION;
    public static final RegistryObject<ISpell> PERMANENT_STRENGTH;
    public static final RegistryObject<ISpell> PERMANENT_RESISTANCE;
    public static final RegistryObject<ISpell> PERMANENT_INVISIBILITY;
    public static final RegistryObject<ISpell> PERMANENT_GLOWING;
    public static final RegistryObject<ISpell> PERMANENT_LUCK;
    public static final RegistryObject<ISpell> PERMANENT_CONDUIT_POWER;
    public static final RegistryObject<ISpell> PERMANENT_MAGIC_IMMUNE;
    public static final RegistryObject<ISpell> TEMPORARY_SPEED;
    public static final RegistryObject<ISpell> TEMPORARY_JUMP_BOOST;
    public static final RegistryObject<ISpell> TEMPORARY_DOLPHINS_GRACE;
    public static final RegistryObject<ISpell> TEMPORARY_WATER_BREATHING;
    public static final RegistryObject<ISpell> TEMPORARY_SLOW_FALLING;
    public static final RegistryObject<ISpell> TEMPORARY_HASTE;
    public static final RegistryObject<ISpell> TEMPORARY_REGENERATION;
    public static final RegistryObject<ISpell> TEMPORARY_FIRE_RESISTANCE;
    public static final RegistryObject<ISpell> TEMPORARY_NIGHT_VISION;
    public static final RegistryObject<ISpell> TEMPORARY_STRENGTH;
    public static final RegistryObject<ISpell> TEMPORARY_RESISTANCE;
    public static final RegistryObject<ISpell> TEMPORARY_INVISIBILITY;
    public static final RegistryObject<ISpell> TEMPORARY_GLOWING;
    public static final RegistryObject<ISpell> TEMPORARY_LUCK;
    public static final RegistryObject<ISpell> TEMPORARY_CONDUIT_POWER;
    public static final RegistryObject<ISpell> TEMPORARY_MAGIC_IMMUNE;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Spells::newRegistry);
        SPELLS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void newRegistry(NewRegistryEvent event) {
        SPELLS_REGISTRY = event.create(new RegistryBuilder().setMaxID(1024).setName(new ResourceLocation("spells_and_shields", "spells")));
    }

    public static void spellsList() {
        if (((Boolean)SpellsConfig.GEN_SPELLS_LIST.get()).booleanValue()) {
            File file = new File(SpellsFileUtil.getOrCreateConfigDir().toFile(), "spells_list.txt");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (Map.Entry entry : SPELLS_REGISTRY.get().getEntries()) {
                    ResourceLocation key = ((ResourceKey)entry.getKey()).m_135782_();
                    writer.write(key.toString());
                    writer.newLine();
                }
                SpellsAndShields.LOGGER.error("Successfully wrote spells list to file {}.", (Object)file.toPath());
            }
            catch (IOException e) {
                SpellsAndShields.LOGGER.error("Could not write spells list to file {}.", (Object)file.toPath());
                e.printStackTrace();
            }
        }
    }

    public static void spellsConfigs() {
        Path p = SpellsFileUtil.getOrCreateSubConfigDir("spells");
        File folder = p.toFile();
        if (!folder.isDirectory() || folder.listFiles() == null) {
            SpellsAndShields.LOGGER.error("Can not read or write spell config files in {} (is it a folder?).", (Object)p);
            SPELLS_REGISTRY.get().getValues().stream().filter(s -> s instanceof IConfigurableSpell).map(s -> (IConfigurableSpell)s).forEach(IConfigurableSpell::applyDefaultConfig);
            return;
        }
        SPELLS_REGISTRY.get().getEntries().stream().filter(e -> e.getValue() instanceof IConfigurableSpell).forEach(entry -> {
            IConfigurableSpell spell = (IConfigurableSpell)entry.getValue();
            ResourceLocation key = ((ResourceKey)entry.getKey()).m_135782_();
            File f = p.resolve(spell.getFileName(key) + ".json").toFile();
            if (((Boolean)SpellsConfig.CREATE_SPELLS_CONFIGS.get()).booleanValue()) {
                try {
                    SpellsFileUtil.writeJsonToFile(f, (JsonElement)spell.makeDefaultConfig());
                    SpellsAndShields.LOGGER.info("Successfully wrote default config of spell {} to file {}.", (Object)key.toString(), (Object)f.toPath());
                }
                catch (Exception e) {
                    SpellsAndShields.LOGGER.error("Failed writing default config of spell {} to file {}.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                    e.printStackTrace();
                }
                spell.applyDefaultConfig();
            } else if (((Boolean)SpellsConfig.LOAD_SPELLS_CONFIGS.get()).booleanValue()) {
                if (!f.exists()) {
                    SpellsAndShields.LOGGER.info("Can not find config of spell {} at {}, applying default config.", (Object)key.toString(), (Object)f.toPath());
                    spell.applyDefaultConfig();
                } else {
                    boolean failed = false;
                    JsonElement json = null;
                    try {
                        json = SpellsFileUtil.readJsonFromFile(f);
                    }
                    catch (Exception e) {
                        failed = true;
                        SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                        e.printStackTrace();
                        spell.applyDefaultConfig();
                    }
                    if (json != null && json.isJsonObject()) {
                        try {
                            spell.readFromConfig(json.getAsJsonObject());
                            SpellsAndShields.LOGGER.info("Successfully read config of spell {} from file {}.", (Object)key.toString(), (Object)f.toPath());
                        }
                        catch (IllegalStateException e) {
                            SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                            e.printStackTrace();
                            spell.applyDefaultConfig();
                        }
                    } else if (!failed) {
                        SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath());
                        spell.applyDefaultConfig();
                    }
                }
            } else {
                spell.applyDefaultConfig();
            }
        });
        if (((Boolean)SpellsConfig.CREATE_SPELLS_CONFIGS.get()).booleanValue()) {
            SpellsConfig.CREATE_SPELLS_CONFIGS.set((Object)false);
            SpellsConfig.CREATE_SPELLS_CONFIGS.save();
        }
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            SpellHolder.getSpellHolder(event.player).ifPresent(spellHolder -> {
                ISpell spell;
                int i;
                LinkedList<Integer> idx = new LinkedList<Integer>();
                for (i = 0; i < 5; ++i) {
                    idx.addLast(i);
                }
                while (!idx.isEmpty()) {
                    i = (Integer)idx.removeFirst();
                    ISpell patt18710$temp = spellHolder.getSpell(i);
                    if (!(patt18710$temp instanceof ITickSpell)) continue;
                    spell = (ITickSpell)patt18710$temp;
                    int amount = 1;
                    for (int j = i + 1; j < 5; ++j) {
                        if (spellHolder.getSpell(j) != spell) continue;
                        idx.removeFirstOccurrence(j);
                        ++amount;
                    }
                    spell.tick((SpellHolder)spellHolder, amount);
                }
                for (i = 0; i < 5; ++i) {
                    ISpell patt19472$temp = spellHolder.getSpell(i);
                    if (!(patt19472$temp instanceof IStackedTickSpell)) continue;
                    spell = (IStackedTickSpell)patt19472$temp;
                    spell.tick((SpellHolder)spellHolder, i);
                }
            });
        }
    }

    private static void tick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            SPELLS_REGISTRY.get().forEach(s -> {
                if (s instanceof ISingletonTickSpell) {
                    ISingletonTickSpell spell = (ISingletonTickSpell)s;
                    spell.tickSingleton();
                }
            });
        }
    }

    public static void registerEventSpells() {
        SPELLS_REGISTRY.get().forEach(spell -> {
            if (spell instanceof IEventSpell) {
                IEventSpell eventSpell = (IEventSpell)spell;
                eventSpell.registerEvents();
            }
        });
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(Spells::playerTick);
        MinecraftForge.EVENT_BUS.addListener(Spells::tick);
    }

    static {
        SPELLS = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "spells"), (String)"spells_and_shields");
        LEAP = SPELLS.register("leap", LeapSpell::new);
        SUMMON_ANIMAL = SPELLS.register("summon_animal", SummonAnimalSpell::new);
        FIRE_BALL = SPELLS.register("fire_ball", FireBallSpell::new);
        BLAST_SMELT = SPELLS.register("blast_smelt", SmeltSpell::new);
        TRANSFER_MANA = SPELLS.register("transfer_mana", TransferManaSpell::new);
        BLOW_ARROW = SPELLS.register("blow_arrow", BlowArrowSpell::new);
        HEALTH_BOOST = SPELLS.register("health_boost", () -> new AttributeSpell(() -> Attributes.f_22276_, 4.0, AttributeModifier.Operation.ADDITION).setIcon(new ResourceLocation("textures/mob_effect/health_boost.png")));
        MANA_BOOST = SPELLS.register("mana_boost", () -> new AttributeSpell(() -> SpellsRegistries.MAX_MANA_ATTRIBUTE.get(), 4.0, AttributeModifier.Operation.ADDITION).setIcon(new ResourceLocation("spells_and_shields", "textures/mob_effect/mana_boost.png")));
        WATER_LEAP = SPELLS.register("water_leap", WaterLeapSpell::new);
        AQUA_AFFINITY = SPELLS.register("aqua_affinity", () -> new AquaAffinitySpell().setSmallIcon(new ResourceLocation("textures/item/enchanted_book.png")));
        WATER_WHIP = SPELLS.register("water_whip", WaterWhipSpell::new);
        POTION_SHOT = SPELLS.register("potion_shot", PotionShotSpell::new);
        FROST_WALKER = SPELLS.register("frost_walker", () -> new WalkerSpell(() -> Blocks.f_49990_, () -> Material.f_76305_, () -> ((Block)Blocks.f_50449_).m_49966_()));
        JUMP = SPELLS.register("jump", JumpSpell::new);
        MANA_SOLES = SPELLS.register("mana_soles", ManaSolesSpell::new);
        FIRE_CHARGE = SPELLS.register("fire_charge", () -> new FireChargeSpell().setSmallIcon(new ResourceLocation("textures/item/fire_charge.png")));
        PRESSURIZE = SPELLS.register("pressurize", PressurizeSpell::new);
        INSTANT_MINE = SPELLS.register("instant_mine", InstantMineSpell::new);
        SPIT_METAL = SPELLS.register("spit_metal", SpitMetalSpell::new);
        FLAMETHROWER = SPELLS.register("flamethrower", FlamethrowerSpell::new);
        LAVA_WALKER = SPELLS.register("lava_walker", () -> new WalkerSpell(() -> Blocks.f_49991_, () -> Material.f_76307_, () -> ((Block)Blocks.f_50080_).m_49966_()));
        SILENCE_TARGET = SPELLS.register("silence_target", () -> new SilenceTargetSpell().setIcon(new ResourceLocation("spells_and_shields", "textures/mob_effect/silence.png")));
        RANDOM_TELEPORT = SPELLS.register("random_teleport", RandomTeleportSpell::new);
        FORCED_TELEPORT = SPELLS.register("forced_teleport", ForcedTeleportSpell::new);
        TELEPORT = SPELLS.register("teleport", TeleportSpell::new);
        LIGHTNING_STRIKE = SPELLS.register("lightning_strike", LightningStrikeSpell::new);
        DRAIN_FLAME = SPELLS.register("drain_flame", DrainFlameSpell::new);
        GROWTH = SPELLS.register("growth", GrowthSpell::new);
        GHAST = SPELLS.register("ghast", () -> new GhastSpell().setIcon(new SpellIcon(new ResourceLocation("textures/entity/ghast/ghast.png"), 16, 16, 16, 16, 64, 32)));
        ENDER_ARMY = SPELLS.register("ender_army", EnderArmySpell::new);
        PERMANENT_REPLENISHMENT = SPELLS.register("permanent_replenishment", () -> new PermanentMobEffectSpell((MobEffect)SpellsRegistries.REPLENISHMENT_EFFECT.get(), 50));
        TEMPORARY_REPLENISHMENT = SPELLS.register("temporary_replenishment", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42300_), (MobEffect)SpellsRegistries.REPLENISHMENT_EFFECT.get()));
        PERMANENT_SPEED = SPELLS.register("permanent_speed", () -> new PermanentMobEffectSpell(MobEffects.f_19596_));
        PERMANENT_JUMP_BOOST = SPELLS.register("permanent_jump_boost", () -> new PermanentMobEffectSpell(MobEffects.f_19603_));
        PERMANENT_DOLPHINS_GRACE = SPELLS.register("permanent_dolphins_grace", () -> new PermanentMobEffectSpell(MobEffects.f_19593_));
        PERMANENT_WATER_BREATHING = SPELLS.register("permanent_water_breathing", () -> new PermanentMobEffectSpell(MobEffects.f_19608_));
        PERMANENT_SLOW_FALLING = SPELLS.register("permanent_slow_falling", () -> new PermanentMobEffectSpell(MobEffects.f_19591_));
        PERMANENT_HASTE = SPELLS.register("permanent_haste", () -> new PermanentMobEffectSpell(MobEffects.f_19598_));
        PERMANENT_REGENERATION = SPELLS.register("permanent_regeneration", () -> new PermanentMobEffectSpell(MobEffects.f_19605_, 50));
        PERMANENT_FIRE_RESISTANCE = SPELLS.register("permanent_fire_resistance", () -> new PermanentMobEffectSpell(MobEffects.f_19607_));
        PERMANENT_NIGHT_VISION = SPELLS.register("permanent_night_vision", () -> new PermanentMobEffectSpell(MobEffects.f_19611_));
        PERMANENT_STRENGTH = SPELLS.register("permanent_strength", () -> new PermanentMobEffectSpell(MobEffects.f_19600_));
        PERMANENT_RESISTANCE = SPELLS.register("permanent_resistance", () -> new PermanentMobEffectSpell(MobEffects.f_19606_));
        PERMANENT_INVISIBILITY = SPELLS.register("permanent_invisibility", () -> new PermanentMobEffectSpell(MobEffects.f_19609_));
        PERMANENT_GLOWING = SPELLS.register("permanent_glowing", () -> new PermanentMobEffectSpell(MobEffects.f_19619_));
        PERMANENT_LUCK = SPELLS.register("permanent_luck", () -> new PermanentMobEffectSpell(MobEffects.f_19621_));
        PERMANENT_CONDUIT_POWER = SPELLS.register("permanent_conduit_power", () -> new PermanentMobEffectSpell(MobEffects.f_19592_));
        PERMANENT_MAGIC_IMMUNE = SPELLS.register("permanent_magic_immune", () -> new PermanentMobEffectSpell((MobEffect)SpellsRegistries.MAGIC_IMMUNE_EFFECT.get()));
        TEMPORARY_SPEED = SPELLS.register("temporary_speed", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42501_), MobEffects.f_19596_));
        TEMPORARY_JUMP_BOOST = SPELLS.register("temporary_jump_boost", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42648_), MobEffects.f_19603_));
        TEMPORARY_DOLPHINS_GRACE = SPELLS.register("temporary_dolphins_grace", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42527_), MobEffects.f_19593_));
        TEMPORARY_WATER_BREATHING = SPELLS.register("temporary_water_breathing", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42529_), MobEffects.f_19608_));
        TEMPORARY_SLOW_FALLING = SPELLS.register("temporary_slow_falling", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42714_), MobEffects.f_19591_));
        TEMPORARY_HASTE = SPELLS.register("temporary_haste", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_151025_), MobEffects.f_19598_));
        TEMPORARY_REGENERATION = SPELLS.register("temporary_regeneration", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42586_), MobEffects.f_19605_));
        TEMPORARY_FIRE_RESISTANCE = SPELLS.register("temporary_fire_resistance", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42542_), MobEffects.f_19607_));
        TEMPORARY_NIGHT_VISION = SPELLS.register("temporary_night_vision", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42677_), MobEffects.f_19611_));
        TEMPORARY_STRENGTH = SPELLS.register("temporary_strength", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42593_), MobEffects.f_19600_));
        TEMPORARY_RESISTANCE = SPELLS.register("temporary_resistance", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42355_), MobEffects.f_19606_));
        TEMPORARY_INVISIBILITY = SPELLS.register("temporary_invisibility", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42592_), MobEffects.f_19609_));
        TEMPORARY_GLOWING = SPELLS.register("temporary_glowing", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42525_), MobEffects.f_19619_));
        TEMPORARY_LUCK = SPELLS.register("temporary_luck", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42415_), MobEffects.f_19621_));
        TEMPORARY_CONDUIT_POWER = SPELLS.register("temporary_conduit_power", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42192_), MobEffects.f_19592_));
        TEMPORARY_MAGIC_IMMUNE = SPELLS.register("temporary_magic_immune", () -> new TemporaryMobEffectSpell(new ItemStack((ItemLike)Items.f_42027_), (MobEffect)SpellsRegistries.MAGIC_IMMUNE_EFFECT.get()));
    }
}

