/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;

public class TalkCache {
    private static final long TIMEOUT = 250L;
    private final Map<UUID, Talk> cache = new HashMap<UUID, Talk>();
    private Supplier<Long> timestampSupplier = System::currentTimeMillis;

    public void setTimestampSupplier(Supplier<Long> timestampSupplier) {
        this.timestampSupplier = timestampSupplier;
    }

    public void updateTalking(UUID entity, boolean whispering) {
        this.cache.put(entity, new Talk(whispering));
    }

    public boolean isTalking(Entity entity) {
        return this.isTalking(entity.m_20148_());
    }

    public boolean isWhispering(Entity entity) {
        return this.isWhispering(entity.m_20148_());
    }

    public boolean isTalking(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null && client.getMicThread().isTalking()) {
            return true;
        }
        Talk lastTalk = this.cache.getOrDefault(entity, new Talk(0L, false));
        return this.timestampSupplier.get() - lastTalk.timestamp < 250L;
    }

    public boolean isWhispering(UUID entity) {
        ClientVoicechat client;
        if (entity.equals(ClientManager.getPlayerStateManager().getOwnID()) && (client = ClientManager.getClient()) != null && client.getMicThread() != null && client.getMicThread().isWhispering()) {
            return true;
        }
        Talk lastTalk = this.cache.getOrDefault(entity, new Talk(0L, false));
        return lastTalk.whispering && this.timestampSupplier.get() - lastTalk.timestamp < 250L;
    }

    private class Talk {
        private final long timestamp;
        private final boolean whispering;

        public Talk(long timestamp, boolean whispering) {
            this.timestamp = timestamp;
            this.whispering = whispering;
        }

        public Talk(boolean whispering) {
            this.timestamp = TalkCache.this.timestampSupplier.get();
            this.whispering = whispering;
        }
    }
}

