/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbDryingRack;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DryingRackRecipeCategory
implements IRecipeCategory<DryingRackRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "drying_rack");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/drying_rack_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public DryingRackRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 53);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()));
    }

    public RecipeType<DryingRackRecipe> getRecipeType() {
        return new RecipeType(UID, DryingRackRecipe.class);
    }

    public Component getTitle() {
        return ((HerbDryingRack)ModBlocks.HERB_DRYING_RACK.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingRackRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 14, 16).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 16).addItemStack(recipe.m_8043_());
    }

    public void draw(DryingRackRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        String dryingTimeString;
        int dryingTime = recipe.getDryingTime();
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        Object object = dryingTime < Integer.MAX_VALUE ? dryingTime / 20 + (String)(dryingTime % 20 == 0 ? "" : "." + Integer.toString(dryingTime % 20)) : (dryingTimeString = "?");
        if (dryingTimeString.charAt(dryingTimeString.length() - 1) == '0' && dryingTime != 0 && dryingTime % 20 != 0) {
            dryingTimeString = dryingTimeString.substring(0, dryingTimeString.length() - 1);
        }
        MutableComponent dip_time_1 = Component.m_237115_((String)"gui.jei.category.dipper.dry_time_1");
        MutableComponent dip_time_3 = Component.m_237110_((String)"gui.jei.category.dipper.resultSeconds", (Object[])new Object[]{dryingTimeString});
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_1, 9.996f, 68.306f, -8355712);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_3, 91.63f, 68.306f, -8355712);
        String outputName = recipe.m_8043_().m_41786_().getString();
        minecraft.f_91062_.m_92883_(matrixStack, outputName, 8.33f, 6.664f, -12566464);
    }
}

