/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.player.extras.stream;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.lava.common.tools.ExecutorTools;
import dev.felnull.imp.include.com.sedmelluq.lava.player.extras.stream.StreamAudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.lava.player.extras.stream.StreamInstance;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class StreamAudioPlayerManager
extends DefaultAudioPlayerManager {
    private static final Logger log = LoggerFactory.getLogger(StreamAudioPlayerManager.class);
    private final Map<String, StreamInstance> streams = new HashMap<String, StreamInstance>();
    private final Predicate<AudioTrack> condition;
    private final ResolutionCache resolutionCache;
    private final int streamFrameCount;

    public StreamAudioPlayerManager(Predicate<AudioTrack> condition, int streamFrameCount) {
        this.condition = condition;
        this.resolutionCache = new ResolutionCache(1000);
        this.streamFrameCount = streamFrameCount;
    }

    @Override
    public AudioPlayer createPlayer() {
        return new StreamAudioPlayer(super.createPlayer(), this);
    }

    @Override
    public Future<Void> loadItem(String identifier, AudioLoadResultHandler resultHandler) {
        if (this.loadFromStream(identifier, resultHandler)) {
            return ExecutorTools.COMPLETED_VOID;
        }
        return super.loadItem(identifier, (AudioLoadResultHandler)new SpyingHandler(resultHandler, identifier));
    }

    @Override
    public Future<Void> loadItemOrdered(Object orderingKey, String identifier, AudioLoadResultHandler resultHandler) {
        if (this.loadFromStream(identifier, resultHandler)) {
            return ExecutorTools.COMPLETED_VOID;
        }
        return super.loadItemOrdered(orderingKey, identifier, resultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamInstance.Cursor openTrack(AudioTrack track, Consumer<StreamInstance.Cursor> detachListener) {
        Map<String, StreamInstance> map = this.streams;
        synchronized (map) {
            StreamInstance instance = this.streams.get(track.getIdentifier());
            if (instance != null) {
                StreamInstance.Cursor cursor = instance.createCursor(detachListener);
                if (cursor != null) {
                    return cursor;
                }
                this.streams.remove(track.getIdentifier());
            }
            if (!this.condition.test(track)) {
                return null;
            }
            instance = new StreamInstance(track, super.createPlayer(), this.streamFrameCount);
            this.streams.put(track.getIdentifier(), instance);
            return instance.createCursor(detachListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromStream(String identifier, AudioLoadResultHandler resultHandler) {
        try {
            StreamInstance stream;
            Map<String, StreamInstance> map = this.streams;
            synchronized (map) {
                String finalIdentifier = DataFormatTools.defaultOnNull(this.resolutionCache.get(identifier), identifier);
                stream = this.streams.get(finalIdentifier);
            }
            if (stream != null) {
                AudioTrack track = stream.getTrack().makeClone();
                log.debug("Track {} (originally {}) loaded using existing stream.", (Object)track.getIdentifier(), (Object)identifier);
                resultHandler.trackLoaded(track);
                return true;
            }
        }
        catch (Exception e) {
            log.error("Error when checking streams for identifier {}.", (Object)identifier);
        }
        return false;
    }

    private static class ResolutionCache
    extends LinkedHashMap<String, String> {
        private final int maximumCacheSize;

        public ResolutionCache(int maximumCacheSize) {
            super(100, 0.75f, true);
            this.maximumCacheSize = maximumCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() >= this.maximumCacheSize;
        }
    }

    private class SpyingHandler
    implements AudioLoadResultHandler {
        private final AudioLoadResultHandler delegate;
        private final String identifier;

        private SpyingHandler(AudioLoadResultHandler delegate, String identifier) {
            this.delegate = delegate;
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trackLoaded(AudioTrack track) {
            if (StreamAudioPlayerManager.this.condition.test(track) && !track.getIdentifier().equals(this.identifier)) {
                Map map = StreamAudioPlayerManager.this.streams;
                synchronized (map) {
                    StreamAudioPlayerManager.this.resolutionCache.put(this.identifier, track.getIdentifier());
                }
            }
            this.delegate.trackLoaded(track);
        }

        @Override
        public void playlistLoaded(AudioPlaylist playlist) {
            this.delegate.playlistLoaded(playlist);
        }

        @Override
        public void noMatches() {
            this.delegate.noMatches();
        }

        @Override
        public void loadFailed(FriendlyException exception) {
            this.delegate.loadFailed(exception);
        }
    }
}

