/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.lava;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.LavaPlayerBaseMusicMedia;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.Pcm16AudioDataFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LavaPlayerManager {
    private static final LavaPlayerManager INSTANCE = new LavaPlayerManager();
    private final Map<String, LavaPlayerBaseMusicMedia> medias = new ConcurrentHashMap<String, LavaPlayerBaseMusicMedia>();
    private AudioDataFormat audioDataFormat;
    private AudioPlayerManager audioPlayerManager;

    public static LavaPlayerManager getInstance() {
        return INSTANCE;
    }

    public void reload() {
        this.medias.clear();
        if (this.audioPlayerManager != null) {
            this.audioPlayerManager.shutdown();
        }
        this.audioDataFormat = new Pcm16AudioDataFormat(2, IamMusicPlayer.CONFIG.sampleRate, 960, false);
        this.audioPlayerManager = this.createAudioPlayerManager();
    }

    public int getChannel() {
        return this.getAudioDataFormat().channelCount;
    }

    public int getSampleRate() {
        return this.getAudioDataFormat().sampleRate;
    }

    public int getBit() {
        return 16;
    }

    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    private AudioPlayerManager createAudioPlayerManager() {
        DefaultAudioPlayerManager audioPlayerManager = new DefaultAudioPlayerManager();
        audioPlayerManager.setFrameBufferDuration(1000);
        audioPlayerManager.setPlayerCleanupThreshold(Long.MAX_VALUE);
        audioPlayerManager.getConfiguration().setResamplingQuality(AudioConfiguration.ResamplingQuality.HIGH);
        audioPlayerManager.getConfiguration().setOpusEncodingQuality(10);
        audioPlayerManager.getConfiguration().setOutputFormat(this.getAudioDataFormat());
        this.registerSourceManager(audioPlayerManager);
        return audioPlayerManager;
    }

    private void registerSourceManager(AudioPlayerManager audioPlayerManager) {
        Comparator<Map.Entry> sc = Comparator.comparingInt(value -> {
            Object patt3137$temp = value.getValue();
            if (patt3137$temp instanceof LavaPlayerBaseMusicMedia) {
                LavaPlayerBaseMusicMedia lavaPlayerBaseMusicMedia = (LavaPlayerBaseMusicMedia)patt3137$temp;
                return lavaPlayerBaseMusicMedia.priority();
            }
            return 0;
        });
        IMPMusicMedias.getAllMedia().entrySet().stream().sorted(sc.reversed()).forEach(v -> {
            MusicMedia media = (MusicMedia)v.getValue();
            if (media instanceof LavaPlayerBaseMusicMedia) {
                LavaPlayerBaseMusicMedia lavaPlayerBaseMusicMedia = (LavaPlayerBaseMusicMedia)media;
                lavaPlayerBaseMusicMedia.registerSourceManager(audioPlayerManager);
                this.medias.put((String)v.getKey(), lavaPlayerBaseMusicMedia);
            }
        });
    }

    public Map<String, LavaPlayerBaseMusicMedia> getMedias() {
        return this.medias;
    }

    public Optional<AudioTrack> loadTrack(String identifier) throws ExecutionException, InterruptedException, TimeoutException {
        final AtomicReference audioTrack = new AtomicReference();
        final AtomicReference fe = new AtomicReference();
        this.audioPlayerManager.loadItem(identifier, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                audioTrack.set(track);
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                for (AudioTrack track : playlist.getTracks()) {
                    track.stop();
                }
            }

            @Override
            public void noMatches() {
            }

            @Override
            public void loadFailed(FriendlyException ex) {
                fe.set(ex);
            }
        }).get(10L, TimeUnit.SECONDS);
        if (fe.get() != null) {
            throw (FriendlyException)fe.get();
        }
        return Optional.ofNullable((AudioTrack)audioTrack.get());
    }

    public AudioDataFormat getAudioDataFormat() {
        return this.audioDataFormat;
    }

    @Nullable
    public Pair<MusicMedia, MusicMediaResult> autoLoad(String sourceName) throws ExecutionException, InterruptedException, TimeoutException {
        LavaPlayerManager lpm = LavaPlayerManager.getInstance();
        Optional<AudioTrack> track = lpm.loadTrack(sourceName);
        if (track.isEmpty() || track.get().getInfo().isStream) {
            return null;
        }
        for (LavaPlayerBaseMusicMedia value : this.medias.values()) {
            if (!value.match(track.get())) continue;
            return Pair.of((Object)value, (Object)value.createResult(track.get()));
        }
        return null;
    }

    public List<AudioTrack> searchYoutube(String name) throws ExecutionException, InterruptedException {
        return (List)this.loadTracks("ytsearch:" + name).getRight();
    }

    public Pair<AudioPlaylist, List<AudioTrack>> loadTracks(String name) throws ExecutionException, InterruptedException {
        final ArrayList tracks = new ArrayList();
        final AtomicReference fe = new AtomicReference();
        final AtomicReference playlist = new AtomicReference();
        this.audioPlayerManager.loadItem(name, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                tracks.add(track);
            }

            @Override
            public void playlistLoaded(AudioPlaylist pl) {
                tracks.addAll(pl.getTracks());
                playlist.set(pl);
            }

            @Override
            public void noMatches() {
            }

            @Override
            public void loadFailed(FriendlyException ex) {
                fe.set(ex);
            }
        }).get();
        if (fe.get() != null) {
            throw (FriendlyException)fe.get();
        }
        return Pair.of((Object)((AudioPlaylist)playlist.get()), tracks);
    }
}

