/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatPropertiesRecipeImpl
extends HeatPropertiesRecipe {
    private final Block block;
    private final BlockState inputState;
    private final BlockState transformHot;
    private final BlockState transformHotFlowing;
    private final BlockState transformCold;
    private final BlockState transformColdFlowing;
    private final Map<String, String> predicates;
    private final IHeatExchangerLogic logic;
    private final int heatCapacity;
    private final int temperature;
    private final double thermalResistance;
    private final String descriptionKey;

    public HeatPropertiesRecipeImpl(ResourceLocation id, Block block, BlockState transformHot, BlockState transformHotFlowing, BlockState transformCold, BlockState transformColdFlowing, int heatCapacity, int temperature, double thermalResistance, Map<String, String> predicates, String descriptionKey) {
        super(id);
        this.block = block;
        this.transformHot = transformHot;
        this.transformHotFlowing = transformHotFlowing;
        this.transformCold = transformCold;
        this.transformColdFlowing = transformColdFlowing;
        this.predicates = ImmutableMap.copyOf(predicates);
        this.heatCapacity = heatCapacity;
        this.temperature = temperature;
        this.thermalResistance = thermalResistance;
        this.descriptionKey = descriptionKey;
        this.logic = new HeatExchangerLogicConstant(temperature, thermalResistance);
        this.inputState = this.makeInputState();
    }

    public HeatPropertiesRecipeImpl(ResourceLocation id, Block block, int temperature, double thermalResistance) {
        this(id, block, null, null, null, null, 0, temperature, thermalResistance, Collections.emptyMap(), "");
    }

    private BlockState makeInputState() {
        if (!this.predicates.isEmpty()) {
            List<String> l = this.predicates.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList();
            try {
                String regName = PneumaticCraftUtils.getRegistryName(this.block).orElseThrow().toString();
                String str = regName + "[" + String.join((CharSequence)",", l) + "]";
                BlockStateParser.BlockResult res = BlockStateParser.m_234704_((Registry)Registry.f_122824_, (String)str, (boolean)false);
                return res.f_234748_();
            }
            catch (CommandSyntaxException e2) {
                return this.block.m_49966_();
            }
        }
        return this.block.m_49966_();
    }

    @Override
    public int getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public double getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.inputState;
    }

    @Override
    public BlockState getTransformHot() {
        return this.transformHot;
    }

    @Override
    public BlockState getTransformCold() {
        return this.transformCold;
    }

    @Override
    public BlockState getTransformHotFlowing() {
        return this.transformHotFlowing;
    }

    @Override
    public BlockState getTransformColdFlowing() {
        return this.transformColdFlowing;
    }

    @Override
    public IHeatExchangerLogic getLogic() {
        return this.logic;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeRegistryId(ForgeRegistries.BLOCKS, (Object)this.block);
        PacketUtil.writeNullableBlockState(buffer, this.transformHot);
        PacketUtil.writeNullableBlockState(buffer, this.transformCold);
        PacketUtil.writeNullableBlockState(buffer, this.transformHotFlowing);
        PacketUtil.writeNullableBlockState(buffer, this.transformColdFlowing);
        buffer.m_130130_(this.predicates.size());
        this.predicates.forEach((key, val) -> {
            buffer.m_130070_(key);
            buffer.m_130070_(val);
        });
        buffer.writeInt(this.temperature);
        buffer.writeInt(this.heatCapacity);
        buffer.writeDouble(this.thermalResistance);
        buffer.m_130070_(this.descriptionKey);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.HEAT_PROPERTIES.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BLOCK_HEAT_PROPERTIES.get();
    }

    @Override
    public boolean matchState(BlockState state) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
            Property iproperty = state.m_60734_().m_49965_().m_61081_(entry.getKey());
            if (iproperty == null) {
                return false;
            }
            Comparable comparable = iproperty.m_6215_(entry.getValue()).orElse(null);
            if (comparable != null && state.m_61143_(iproperty) == comparable) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> getBlockStatePredicates() {
        return this.predicates;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public static class Serializer<T extends HeatPropertiesRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            int temperature;
            Fluid fluid;
            Block block;
            BlockState transformHot = null;
            BlockState transformHotFlowing = null;
            BlockState transformCold = null;
            BlockState transformColdFlowing = null;
            HashMap<String, String> predicates = new HashMap<String, String>();
            if (json.has("block") && json.has("fluid")) {
                throw new JsonSyntaxException("heat properties entry must have only one of \"block\" or \"fluid\" fields!");
            }
            if (json.has("block")) {
                ResourceLocation blockId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
                if (blockId.toString().equals("minecraft:air")) {
                    throw new JsonSyntaxException("minecraft:air block heat properties may not be changed!");
                }
                if (!ModList.get().isLoaded(blockId.m_135827_())) {
                    Log.info("ignoring heat properties for block %s: mod not loaded", blockId);
                    return null;
                }
                block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
                this.validateBlock(blockId, block);
                fluid = Objects.requireNonNull(block).m_49966_().m_60819_().m_76152_();
            } else if (json.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
                if (!ModList.get().isLoaded(fluidId.m_135827_())) {
                    Log.info("ignoring heat properties for fluid %s: mod not loaded", fluidId);
                    return null;
                }
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
                if (fluid == null || fluid == Fluids.f_76191_) {
                    throw new JsonSyntaxException("unknown fluid " + fluidId);
                }
                block = fluid.m_76145_().m_76188_().m_60734_();
                this.validateBlock(fluidId, block);
            } else {
                throw new JsonSyntaxException("heat properties entry must have a \"block\" or \"fluid\" field!");
            }
            int totalHeat = 0;
            if (json.has("heatCapacity")) {
                totalHeat = json.get("heatCapacity").getAsInt();
            } else if (fluid != Fluids.f_76191_) {
                totalHeat = (Integer)ConfigHelper.common().heat.defaultFluidHeatCapacity.get();
            }
            if (totalHeat != 0) {
                transformHot = this.maybeGetBlockState(block, json, "transformHot");
                transformHotFlowing = this.maybeGetBlockState(block, json, "transformHotFlowing");
                transformCold = this.maybeGetBlockState(block, json, "transformCold");
                transformColdFlowing = this.maybeGetBlockState(block, json, "transformColdFlowing");
            }
            if (json.has("temperature")) {
                temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            } else {
                if (fluid == Fluids.f_76191_) {
                    throw new JsonSyntaxException(block + ": Non-fluid definitions must have a 'temperature' field!");
                }
                temperature = fluid.getFluidType().getTemperature();
            }
            double thermalResistance = json.has("thermalResistance") ? json.get("thermalResistance").getAsDouble() : (fluid == Fluids.f_76191_ ? ((Double)ConfigHelper.common().heat.blockThermalResistance.get()).doubleValue() : ((Double)ConfigHelper.common().heat.fluidThermalResistance.get()).doubleValue());
            if (json.has("statePredicate")) {
                json.getAsJsonObject("statePredicate").entrySet().forEach(entry -> {
                    if (block.m_49965_().m_61081_((String)entry.getKey()) == null) {
                        throw new JsonSyntaxException("unknown blockstate property " + (String)entry.getKey() + " for block" + block);
                    }
                    predicates.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                });
            }
            String descriptionKey = GsonHelper.m_13851_((JsonObject)json, (String)"description", (String)"");
            return this.factory.create(recipeId, block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, totalHeat, temperature, thermalResistance, predicates, descriptionKey);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Block block = (Block)buffer.readRegistryIdSafe(Block.class);
            BlockState transformHot = PacketUtil.readNullableBlockState(buffer);
            BlockState transformCold = PacketUtil.readNullableBlockState(buffer);
            BlockState transformHotFlowing = PacketUtil.readNullableBlockState(buffer);
            BlockState transformColdFlowing = PacketUtil.readNullableBlockState(buffer);
            ImmutableMap.Builder predBuilder = ImmutableMap.builder();
            int nPredicates = buffer.m_130242_();
            for (int i = 0; i < nPredicates; ++i) {
                predBuilder.put((Object)buffer.m_130277_(), (Object)buffer.m_130277_());
            }
            int temperature = buffer.readInt();
            int heatCapacity = buffer.readInt();
            double thermalResistance = buffer.readDouble();
            String descriptionKey = buffer.m_130277_();
            return this.factory.create(recipeId, block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, heatCapacity, temperature, thermalResistance, (Map<String, String>)predBuilder.build(), descriptionKey);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        private void validateBlock(ResourceLocation blockId, Block block) {
            if (block == null || block == Blocks.f_50016_) {
                throw new JsonSyntaxException("unknown block id: " + blockId.toString());
            }
        }

        private BlockState parseBlockState(String str) {
            try {
                return BlockStateParser.m_234704_((Registry)Registry.f_122824_, (String)str, (boolean)false).f_234748_();
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(String.format("invalid blockstate [%s] - %s", str, e.getMessage()));
            }
        }

        private BlockState maybeGetBlockState(Block b, JsonObject json, String field) {
            if (!json.has(field)) {
                return null;
            }
            JsonObject sub = json.get(field).getAsJsonObject();
            if (sub.has("block")) {
                return this.parseBlockState(GsonHelper.m_13906_((JsonObject)sub, (String)"block"));
            }
            if (sub.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)sub, (String)"fluid"));
                if (ForgeRegistries.FLUIDS.containsKey(fluidId)) {
                    return ((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)).m_76145_().m_76188_();
                }
                throw new JsonSyntaxException(String.format("unknown fluid '%s' for field '%s' in block '%s'", fluidId, field, b));
            }
            throw new JsonSyntaxException(String.format("block %s must have either a 'block' or 'fluid' section!", b));
        }

        public static interface IFactory<T extends HeatPropertiesRecipe> {
            public T create(ResourceLocation var1, Block var2, BlockState var3, BlockState var4, BlockState var5, BlockState var6, int var7, int var8, double var9, Map<String, String> var11, String var12);
        }
    }
}

