/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIRightClickBlock;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;

public class ProgWidgetBlockRightClick
extends ProgWidgetPlace
implements IBlockRightClicker,
ISidedWidget {
    private Direction clickSide = Direction.UP;
    private boolean sneaking;
    private IBlockRightClicker.RightClickType clickType = IBlockRightClicker.RightClickType.CLICK_ITEM;

    public ProgWidgetBlockRightClick() {
        super((ProgWidgetType)ModProgWidgets.BLOCK_RIGHT_CLICK.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_BLOCK_RIGHT_CLICK;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIRightClickBlock(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public boolean supportsMaxActions() {
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public IBlockRightClicker.RightClickType getClickType() {
        return this.clickType;
    }

    public void setClickType(IBlockRightClicker.RightClickType clickType) {
        this.clickType = clickType;
    }

    public Direction getClickSide() {
        return this.clickSide;
    }

    public void setClickSide(Direction clickSide) {
        this.clickSide = clickSide;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.blockRightClick.clickSide").m_130946_(": " + ClientUtils.translateDirection(this.clickSide)));
        if (this.sneaking) {
            curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.blockRightClick.sneaking"));
        }
        curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.blockRightClick.operation").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)this.clickType.getTranslationKey())));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.sneaking) {
            tag.m_128379_("sneaking", true);
        }
        tag.m_128405_("dir", this.clickSide.m_122411_());
        tag.m_128359_("clickType", this.clickType.toString());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.sneaking = tag.m_128471_("sneaking");
        this.clickSide = Direction.m_122376_((int)tag.m_128451_("dir"));
        this.clickType = tag.m_128441_("clickType") ? IBlockRightClicker.RightClickType.valueOf(tag.m_128461_("clickType")) : IBlockRightClicker.RightClickType.CLICK_ITEM;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.sneaking);
        buf.m_130068_((Enum)this.clickSide);
        buf.m_130068_((Enum)this.clickType);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.sneaking = buf.readBoolean();
        this.clickSide = (Direction)buf.m_130066_(Direction.class);
        this.clickType = (IBlockRightClicker.RightClickType)buf.m_130066_(IBlockRightClicker.RightClickType.class);
    }

    @Override
    public void setSides(boolean[] sides) {
        this.clickSide = ISidedWidget.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ISidedWidget.getSidesFromDir(this.clickSide);
    }
}

