/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class WidgetTemperature
extends AbstractWidget
implements ITooltipProvider {
    private int temperature;
    private int tickInterval;
    private TemperatureRange totalRange;
    private TemperatureRange operatingRange;
    private boolean drawText = true;
    private boolean showOperatingRange = true;

    public WidgetTemperature(int xIn, int yIn, TemperatureRange totalRange, int initialTemp, int tickInterval) {
        super(xIn, yIn, 13, 50, (Component)Component.m_237119_());
        this.totalRange = totalRange;
        this.temperature = initialTemp;
        this.tickInterval = tickInterval;
        this.operatingRange = null;
    }

    public void setTotalRange(@Nonnull TemperatureRange totalRange) {
        this.totalRange = totalRange;
    }

    public TemperatureRange getTotalRange() {
        return this.totalRange;
    }

    public WidgetTemperature setOperatingRange(@Nullable TemperatureRange operatingRange) {
        this.operatingRange = operatingRange;
        return this;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }

    public <T extends WidgetTemperature> T setDrawText(boolean drawText) {
        this.drawText = drawText;
        return (T)this;
    }

    public WidgetTemperature setShowOperatingRange(boolean showOperatingRange) {
        this.showOperatingRange = showOperatingRange;
        return this;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            GuiUtils.bindTexture(Textures.WIDGET_TEMPERATURE);
            WidgetTemperature.m_93133_((PoseStack)matrixStack, (int)(this.f_93620_ + 6), (int)this.f_93621_, (float)6.0f, (float)0.0f, (int)7, (int)50, (int)18, (int)50);
            int barLength = this.getYPos(this.temperature);
            WidgetTemperature.m_93133_((PoseStack)matrixStack, (int)(this.f_93620_ + 7), (int)(this.f_93621_ - 1 + this.f_93619_ - barLength), (float)13.0f, (float)(this.f_93619_ - barLength - 2), (int)5, (int)barLength, (int)18, (int)50);
            this.drawTicks(matrixStack);
            if (this.drawText) {
                GuiUtils.drawScaledText(matrixStack, Minecraft.m_91087_().f_91062_, TemperatureRange.TemperatureScale.CELSIUS.symbol(), this.f_93620_ + 7, this.f_93621_ + this.f_93619_ + 1, -12566464, 0.5f);
            }
            this.drawOperatingTempMarkers(matrixStack);
        }
    }

    public void drawTicks(PoseStack matrixStack) {
        Font font = Minecraft.m_91087_().f_91062_;
        int n = 0;
        for (int tickTempC = WidgetTemperature.findNearestCelsius(this.totalRange.getMin() - 273, this.tickInterval); tickTempC <= this.totalRange.getMax() - 273; tickTempC += this.tickInterval) {
            int yOffset = this.getYPos(tickTempC + 273);
            this.m_93154_(matrixStack, this.f_93620_ + 4, this.f_93620_ + 6, this.f_93621_ - 1 + this.f_93619_ - yOffset, -1606401984);
            if (yOffset != 0 && yOffset != this.f_93619_ - 1) {
                this.m_93154_(matrixStack, this.f_93620_ + 6, this.f_93620_ + 8, this.f_93621_ - 1 + this.f_93619_ - yOffset, -2134851392);
            }
            if (this.drawText && n % 2 == 0) {
                String s = Integer.toString(tickTempC);
                GuiUtils.drawScaledText(matrixStack, font, s, this.f_93620_ + 4 - font.m_92895_(s) / 2, this.f_93621_ - 2 + this.f_93619_ - yOffset, -12566464, 0.5f);
            }
            ++n;
        }
    }

    public void drawOperatingTempMarkers(PoseStack matrixStack) {
        if (this.operatingRange != null) {
            int yOffset;
            if (this.totalRange.inRange(this.operatingRange.getMax())) {
                yOffset = this.getYPos(this.operatingRange.getMax());
                this.m_93154_(matrixStack, this.f_93620_ + 7, this.f_93620_ + 11, this.f_93621_ + 1 + this.f_93619_ - yOffset, -2039744);
                this.m_93154_(matrixStack, this.f_93620_ + 9, this.f_93620_ + 9, this.f_93621_ + this.f_93619_ - yOffset, -2132746176);
                this.m_93154_(matrixStack, this.f_93620_ + 8, this.f_93620_ + 10, this.f_93621_ - 1 + this.f_93619_ - yOffset, -2132746176);
                this.m_93154_(matrixStack, this.f_93620_ + 7, this.f_93620_ + 11, this.f_93621_ - 2 + this.f_93619_ - yOffset, -2132746176);
            }
            if (this.totalRange.inRange(this.operatingRange.getMin())) {
                yOffset = this.getYPos(this.operatingRange.getMin());
                this.m_93154_(matrixStack, this.f_93620_ + 7, this.f_93620_ + 11, this.f_93621_ - 1 + this.f_93619_ - yOffset, -2039744);
                this.m_93154_(matrixStack, this.f_93620_ + 9, this.f_93620_ + 9, this.f_93621_ + this.f_93619_ - yOffset, -2132746176);
                this.m_93154_(matrixStack, this.f_93620_ + 8, this.f_93620_ + 10, this.f_93621_ + 1 + this.f_93619_ - yOffset, -2132746176);
                this.m_93154_(matrixStack, this.f_93620_ + 7, this.f_93620_ + 11, this.f_93621_ + 2 + this.f_93619_ - yOffset, -2132746176);
            }
        }
    }

    private int getYPos(int temp) {
        int h = this.f_93619_ - 1;
        return Mth.m_14045_((int)((temp - this.totalRange.getMin()) * h / (this.totalRange.getMax() - this.totalRange.getMin())), (int)0, (int)(h + 4));
    }

    private static int findNearestCelsius(int temp, int interval) {
        int q = temp % interval;
        if (q == 0) {
            return temp;
        }
        int n = temp - q;
        return Math.max(-273, n - interval);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shift) {
        curTip.add(HeatUtil.formatHeatString(this.temperature));
        if (this.operatingRange != null && this.showOperatingRange) {
            ChatFormatting tf = this.operatingRange.inRange(this.temperature) ? ChatFormatting.GREEN : ChatFormatting.GOLD;
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.requiredTemperatureString", this.operatingRange.asString(TemperatureRange.TemperatureScale.CELSIUS)).m_130940_(tf));
        }
    }

    public void autoScaleForTemperature() {
        if (this.temperature < 173) {
            this.setTotalRange(TemperatureRange.of(0, 275));
            this.setTickInterval(25);
        } else if (this.temperature < 273) {
            this.setTotalRange(TemperatureRange.of(123, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 373) {
            this.setTotalRange(TemperatureRange.of(273, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 473) {
            this.setTotalRange(TemperatureRange.of(273, 473));
            this.setTickInterval(25);
        } else if (this.temperature < 773) {
            this.setTotalRange(TemperatureRange.of(273, 773));
            this.setTickInterval(50);
        } else if (this.temperature < 1273) {
            this.setTotalRange(TemperatureRange.of(273, 1273));
            this.setTickInterval(100);
        } else {
            this.setTotalRange(TemperatureRange.of(273, 2273));
            this.setTickInterval(200);
        }
    }

    public static int roundDownK(int tempK, int interval) {
        int tempC = tempK - 273;
        int rem = tempC % interval;
        return tempK - rem;
    }

    public static int roundUpK(int tempK, int interval) {
        return WidgetTemperature.roundDownK(tempK, interval) + interval;
    }

    public static WidgetTemperature fromOperatingRange(int x, int y, TemperatureRange range) {
        TemperatureRange totalRange;
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        if (range.hasMin() && range.hasMax()) {
            totalRange = TemperatureRange.of(WidgetTemperature.roundDownK(range.getMin(), interval), WidgetTemperature.roundUpK(range.getMax(), interval));
        } else if (range.hasMin()) {
            int minK = WidgetTemperature.roundDownK(range.getMin(), interval);
            totalRange = TemperatureRange.of(minK, minK + interval * 2);
        } else {
            totalRange = range.hasMax() ? TemperatureRange.of(0, WidgetTemperature.roundUpK(range.getMax(), interval)) : TemperatureRange.of(0, 2273);
        }
        interval = WidgetTemperature.calcInterval(totalRange.getMax() - totalRange.getMin()) * 2;
        return new WidgetTemperature(x, y, totalRange, range.getMin(), interval).setOperatingRange(range);
    }

    public static int calcInterval(int r) {
        int r1 = r / 10;
        if (r1 >= 200) {
            return 200;
        }
        if (r1 >= 100) {
            return 100;
        }
        if (r1 >= 50) {
            return 50;
        }
        if (r1 >= 15) {
            return 25;
        }
        if (r1 >= 5) {
            return 10;
        }
        return 5;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

