/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ElevatorMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ElevatorScreen
extends AbstractPneumaticCraftContainerScreen<ElevatorMenu, ElevatorBaseBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetTextField floorNameField;
    private WidgetLabel noFloorsLabel;
    private WidgetLabel floorNumberLabel;
    private WidgetButtonExtended cycleDown;
    private WidgetButtonExtended cycleUp;
    private int currentEditedFloor;

    public ElevatorScreen(ElevatorMenu container, Inventory inventoryPlayer, Component displayName) {
        super(container, inventoryPlayer, displayName);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.ELEVATOR_BASE.get()), -22016, false);
        WidgetAnimatedStat floorNameStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.floorNames", new Object[0]), new ItemStack((ItemLike)ModBlocks.ELEVATOR_CALLER.get()), -16755456, false);
        floorNameStat.setMinimumExpandedDimensions(120, 85);
        this.floorNameField = new WidgetTextField(this.f_96547_, 6, 60, 120, 20);
        this.floorNameField.m_94144_(((ElevatorBaseBlockEntity)this.te).getFloorName(this.currentEditedFloor));
        this.floorNameField.m_94151_(this::updateFloor);
        floorNameStat.addSubWidget((AbstractWidget)this.floorNameField);
        this.noFloorsLabel = new WidgetLabel(5, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.noCallers", new Object[0])).setColor(-1);
        floorNameStat.addSubWidget(this.noFloorsLabel);
        this.floorNumberLabel = new WidgetLabel(65, 40, (Component)Component.m_237119_()).setAlignment(WidgetLabel.Alignment.CENTRE).setColor(-1);
        floorNameStat.addSubWidget(this.floorNumberLabel);
        this.cycleDown = new WidgetButtonExtended(5, 35, 20, 20, "\u27f5", button -> this.cycleFloor(-1));
        floorNameStat.addSubWidget((AbstractWidget)this.cycleDown);
        this.cycleUp = new WidgetButtonExtended(105, 35, 20, 20, "\u27f6", button -> this.cycleFloor(1));
        floorNameStat.addSubWidget((AbstractWidget)this.cycleUp);
    }

    private void cycleFloor(int dir) {
        if (((ElevatorBaseBlockEntity)this.te).floorHeights.length > 0) {
            this.currentEditedFloor += dir;
            if (this.currentEditedFloor >= ((ElevatorBaseBlockEntity)this.te).floorHeights.length) {
                this.currentEditedFloor = 0;
            } else if (this.currentEditedFloor < 0) {
                this.currentEditedFloor = ((ElevatorBaseBlockEntity)this.te).floorHeights.length - 1;
            }
            this.floorNameField.m_94144_(((ElevatorBaseBlockEntity)this.te).getFloorName(this.currentEditedFloor));
            this.floorNameField.m_94178_(true);
        }
    }

    private void updateFloor(String floorName) {
        ((ElevatorBaseBlockEntity)this.te).setFloorName(this.currentEditedFloor, floorName);
        this.sendDelayed(5);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, this.currentEditedFloor));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ELEVATOR;
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float opacity, int x, int y) {
        super.m_7286_(matrixStack, opacity, x, y);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.statusStat.setText(this.getStatusText());
        this.cycleUp.f_93623_ = ((ElevatorBaseBlockEntity)this.te).floorHeights.length > 0;
        this.cycleDown.f_93623_ = this.cycleUp.f_93623_;
        this.noFloorsLabel.f_93624_ = ((ElevatorBaseBlockEntity)this.te).floorHeights.length == 0;
        this.floorNumberLabel.f_93624_ = ((ElevatorBaseBlockEntity)this.te).floorHeights.length > 0;
        this.floorNameField.f_93623_ = ((ElevatorBaseBlockEntity)this.te).floorHeights.length > 0;
        this.floorNumberLabel.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.floorNumber", this.currentEditedFloor + 1, ((ElevatorBaseBlockEntity)this.te).floorHeights.length));
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.extension", PneumaticCraftUtils.roundNumberTo(((ElevatorBaseBlockEntity)this.te).extension, 1)).m_130940_(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.maxExtension", PneumaticCraftUtils.roundNumberTo(((ElevatorBaseBlockEntity)this.te).getMaxElevatorHeight(), 1)).m_130940_(ChatFormatting.BLACK));
        return text;
    }

    @Override
    protected void addWarnings(List<Component> textList) {
        super.addWarnings(textList);
        if ((double)((ElevatorBaseBlockEntity)this.te).getMaxElevatorHeight() == ((ElevatorBaseBlockEntity)this.te).extension) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.elevator.fully_extended", new Object[0]));
        }
    }
}

