/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumSet;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncClassifyFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class ClassifyFilterScreen
extends AbstractPneumaticCraftScreen {
    private final InteractionHand handIn;
    private final Set<ClassifyFilterItem.FilterCondition> conditions = EnumSet.noneOf(ClassifyFilterItem.FilterCondition.class);
    private boolean matchAll;
    private WidgetButtonExtended matchButton;

    private ClassifyFilterScreen(Component title, InteractionHand handIn) {
        super(title);
        this.handIn = handIn;
        this.xSize = 256;
        this.ySize = 202;
        ClassifyFilterItem.FilterSettings settings = ClassifyFilterItem.FilterSettings.fromStack(ClientUtils.getClientPlayer().m_21120_(handIn));
        this.conditions.addAll(settings.filterConditions());
        this.matchAll = settings.matchAll();
    }

    public static void openGui(Component title, InteractionHand handIn) {
        Minecraft.m_91087_().m_91152_((Screen)new ClassifyFilterScreen(title, handIn));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft + 55;
        int y = this.guiTop + 20;
        for (ClassifyFilterItem.FilterCondition cond : ClassifyFilterItem.FilterCondition.values()) {
            WidgetCheckBox cb = (WidgetCheckBox)this.m_142416_((GuiEventListener)new WidgetCheckBox(x + 20, y + 5, 20, (Component)Component.m_237119_(), b -> this.toggleCondition(cond)).setTooltipKey(cond.getTranslationKey()).setChecked(this.conditions.contains(cond)));
            this.m_142416_((GuiEventListener)new WidgetButtonExtended(x, y, 20, 20, "", b -> {
                this.toggleCondition(cond);
                cb.setChecked(this.conditions.contains(cond));
            }).setRenderStacks(cond.getIcon()).setVisible(false).setTooltipKey(cond.getTranslationKey(), new Object[0]));
            if ((y += 20) <= this.guiTop + 140) continue;
            x += 100;
            y = this.guiTop + 20;
        }
        MutableComponent txtAny = ClassifyFilterItem.xlateMatch(false);
        MutableComponent txtAll = ClassifyFilterItem.xlateMatch(true);
        int w = Math.max(this.f_96547_.m_92852_((FormattedText)txtAll), this.f_96547_.m_92852_((FormattedText)txtAny)) + 20;
        this.matchButton = (WidgetButtonExtended)this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.guiLeft + (this.xSize - w) / 2, this.guiTop + 170, w, 20, (Component)(this.matchAll ? txtAll : txtAny), b -> this.toggleMatchAll()));
    }

    private void toggleMatchAll() {
        this.matchAll = !this.matchAll;
        this.matchButton.m_93666_((Component)ClassifyFilterItem.xlateMatch(this.matchAll));
        NetworkHandler.sendToServer(new PacketSyncClassifyFilter(this.matchAll, this.conditions, this.handIn));
    }

    private void toggleCondition(ClassifyFilterItem.FilterCondition cond) {
        if (this.conditions.contains(cond)) {
            this.conditions.remove(cond);
        } else {
            this.conditions.add(cond);
        }
        NetworkHandler.sendToServer(new PacketSyncClassifyFilter(this.matchAll, this.conditions, this.handIn));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTicks);
    }

    @Override
    protected void drawForeground(PoseStack matrixStack, int x, int y, float partialTicks) {
        super.drawForeground(matrixStack, x, y, partialTicks);
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, (float)this.guiLeft + (float)(this.xSize - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2.0f, (float)(this.guiTop + 8), 0x404040);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_WIDGET_AREA;
    }
}

