/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiFissionReactorStats
extends GuiMekanismTile<TileEntityFissionReactorCasing, EmptyTileContainer<TileEntityFissionReactorCasing>> {
    private GuiTextField rateLimitField;

    public GuiFissionReactorStats(EmptyTileContainer<TileEntityFissionReactorCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.MAIN));
        this.addRenderableWidget((GuiElement)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactorStats)GuiFissionReactorStats.this).tile).getMultiblock()).lastBurnRate});
            }

            public double getLevel() {
                FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)GuiFissionReactorStats.this.tile).getMultiblock();
                return Math.min(1.0, multiblock.lastBurnRate / (double)multiblock.getMaxBurnRate());
            }
        }, 5, 114, this.f_97726_ - 12));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        this.rateLimitField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 77, 128, 54, 12));
        this.rateLimitField.setEnterHandler(this::setRateLimit);
        this.rateLimitField.setInputValidator(InputValidator.DECIMAL);
        long adjustedMaxBurn = Math.max(0L, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getMaxBurnRate() - 1L);
        this.rateLimitField.setMaxLength(Long.toString(adjustedMaxBurn).length() + 3);
        this.rateLimitField.addCheckmarkButton(this::setRateLimit);
    }

    private void setRateLimit() {
        if (!this.rateLimitField.getText().isEmpty()) {
            try {
                double limit = Double.parseDouble(this.rateLimitField.getText());
                if (limit >= 0.0 && limit <= (double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getMaxBurnRate()) {
                    limit = UnitDisplayUtils.roundDecimals((double)limit);
                    MekanismGenerators.packetHandler().sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.INJECTION_RATE, (BlockEntity)this.tile, limit));
                    this.rateLimitField.setText("");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_HEAT_STATISTICS.translate(new Object[0]), 6.0f, 20.0f, this.headingTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_HEAT_CAPACITY.translate(new Object[]{TextUtils.format((long)((long)multiblock.heatCapacitor.getHeatCapacity()))}), 6.0f, 32.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_SURFACE_AREA.translate(new Object[]{TextUtils.format((long)multiblock.surfaceArea)}), 6.0f, 42.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_BOIL_EFFICIENCY.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getBoilEfficiency()}), 6.0f, 52.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_FUEL_STATISTICS.translate(new Object[0]), 6.0f, 68.0f, this.headingTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_MAX_BURN_RATE.translate(new Object[]{TextUtils.format((long)multiblock.getMaxBurnRate())}), 6.0f, 80.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_RATE_LIMIT.translate(new Object[]{multiblock.rateLimit}), 6.0f, 90.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_CURRENT_BURN_RATE.translate(new Object[0]), 6.0f, 104.0f, this.titleTextColor(), this.f_97726_ - 12);
        this.drawTextScaledBound(matrix, (Component)GeneratorsLang.FISSION_SET_RATE_LIMIT.translate(new Object[0]), 6.0f, 130.0f, this.titleTextColor(), 69.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

