/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class BlockSuffixConfig
extends AbstractConfigType {
    private static final VariantMap EMPTY_VARIANT_MAP = new VariantMap(new HashMap<String, Block>());
    @Config
    public List<String> knownSuffixes;
    @Config
    public List<String> testedMods;
    private Map<Block, VariantMap> blockVariants = new HashMap<Block, VariantMap>();
    private List<String> sortedSuffixes;

    public BlockSuffixConfig(List<String> knownSuffixes, List<String> testedMods) {
        this.knownSuffixes = knownSuffixes;
        this.testedMods = testedMods;
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        this.blockVariants.clear();
        this.sortedSuffixes = new ArrayList<String>(this.knownSuffixes);
        this.sortedSuffixes.sort((s1, s2) -> {
            int ct1 = s1.replaceAll("[^_]", "").length();
            int ct2 = s2.replaceAll("[^_]", "").length();
            return ct2 - ct1;
        });
    }

    public String getVariantForBlock(Block block) {
        String name = Registry.f_122824_.m_7981_((Object)block).m_135815_();
        for (String s : this.sortedSuffixes) {
            String check = String.format("_%s", s);
            if (!name.endsWith(check)) continue;
            return s;
        }
        return null;
    }

    public Block getBlockForTarget(Block block, Block target) {
        return this.getBlockForVariant(block, this.getVariantForBlock(target));
    }

    public Block getBlockForVariant(Block block, String variant) {
        this.blockVariants.clear();
        if (variant == null || !this.sortedSuffixes.contains(variant)) {
            return block;
        }
        VariantMap map = this.getVariants(block);
        Block ret = map.variants.get(variant);
        if (ret != null) {
            return ret;
        }
        return block;
    }

    private VariantMap getVariants(Block block) {
        if (this.blockVariants.containsKey(block)) {
            return this.blockVariants.get(block);
        }
        HashMap<String, Block> newVariants = new HashMap<String, Block>();
        for (String s : this.sortedSuffixes) {
            Block suffixed = this.getSuffixedBlock(block, s);
            if (suffixed == null) continue;
            newVariants.put(s, suffixed);
        }
        if (newVariants.isEmpty()) {
            this.blockVariants.put(block, EMPTY_VARIANT_MAP);
        } else {
            this.blockVariants.put(block, new VariantMap(newVariants));
        }
        return this.getVariants(block);
    }

    private Block getSuffixedBlock(Block ogBlock, String suffix) {
        String name;
        ResourceLocation resloc = Registry.f_122824_.m_7981_((Object)ogBlock);
        String namespace = resloc.m_135827_();
        Block ret = this.getSuffixedBlock(namespace, name = resloc.m_135815_(), suffix);
        if (ret != null) {
            return ret;
        }
        for (String mod : this.testedMods) {
            ret = this.getSuffixedBlock(mod, name, suffix);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Block getSuffixedBlock(String namespace, String name, String suffix) {
        String singular;
        Block singularAttempt;
        if (name.endsWith("planks") && (singularAttempt = this.getSuffixedBlock(namespace, singular = name.substring(0, name.length() - 7), suffix)) != null) {
            return singularAttempt;
        }
        if (name.endsWith("s") && (singularAttempt = this.getSuffixedBlock(namespace, singular = name.substring(0, name.length() - 1), suffix)) != null) {
            return singularAttempt;
        }
        String targetStr = String.format("%s:%s_%s", namespace, name, suffix);
        ResourceLocation target = new ResourceLocation(targetStr);
        Block ret = (Block)Registry.f_122824_.m_7745_(target);
        if (ret == Blocks.f_50016_) {
            return null;
        }
        return ret;
    }

    private record VariantMap(Map<String, Block> variants) {
    }
}

