/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class HornItem
extends Item {
    public HornItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5929_(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int time) {
        if (!world.f_46443_) {
            if (time != this.m_8105_(stack) && time % 5 == 0) {
                HornItem.breakGrass(world, stack, living.m_20183_(), living);
            }
            world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), BotaniaSounds.hornDoot, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void breakGrass(Level world, ItemStack stack, BlockPos srcPos, @Nullable LivingEntity user) {
        HornHarvestable harvestable;
        BlockEntity be;
        HornHarvestable.EnumHornType type = null;
        if (stack.m_150930_(BotaniaItems.grassHorn)) {
            type = HornHarvestable.EnumHornType.WILD;
        } else if (stack.m_150930_(BotaniaItems.leavesHorn)) {
            type = HornHarvestable.EnumHornType.CANOPY;
        } else if (stack.m_150930_(BotaniaItems.snowHorn)) {
            type = HornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)srcPos.m_7918_(-range, -rangeY, -range), (BlockPos)srcPos.m_7918_(range, rangeY, range))) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            be = world.m_7702_(pos);
            harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, pos, state, be);
            if (BergamuteBlockEntity.isBergamuteNearby(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) || !(harvestable != null ? harvestable.canHornHarvest(world, pos, stack, type, user) : type == HornHarvestable.EnumHornType.WILD && block instanceof BushBlock && !state.m_204336_(BotaniaTags.Blocks.SPECIAL_FLOWERS) || type == HornHarvestable.EnumHornType.CANOPY && state.m_204336_(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE) || type == HornHarvestable.EnumHornType.COVERING && state.m_204336_(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE))) continue;
            coords.add(pos.m_7949_());
        }
        Collections.shuffle(coords);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            BlockState state;
            BlockPos currCoords = (BlockPos)coords.get(i);
            harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state = world.m_8055_(currCoords), be = world.m_7702_(currCoords));
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type, user)) {
                harvestable.harvestByHorn(world, currCoords, stack, type, user);
                continue;
            }
            world.m_46961_(currCoords, true);
        }
    }
}

