/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.bag.FlowerPouchContainer;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ItemBackedInventory;
import vazkii.botania.xplat.XplatAbstractions;

public class FlowerPouchItem
extends Item {
    public static final int SIZE = 2 * DyeColor.values().length;

    public FlowerPouchItem(Item.Properties props) {
        super(props);
    }

    private static boolean isMysticalFlower(ItemStack stack) {
        Block blk = Block.m_49814_((Item)stack.m_41720_());
        return !stack.m_41619_() && blk.getClass() == BotaniaFlowerBlock.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(int slot, ItemStack stack) {
        Block blk = Block.m_49814_((Item)stack.m_41720_());
        if (slot < 16) {
            if (!FlowerPouchItem.isMysticalFlower(stack)) return false;
            if (slot != ((BotaniaFlowerBlock)blk).color.m_41060_()) return false;
            return true;
        }
        if (!(blk instanceof BotaniaDoubleFlowerBlock)) return false;
        BotaniaDoubleFlowerBlock flower = (BotaniaDoubleFlowerBlock)blk;
        if (slot - 16 != flower.color.m_41060_()) return false;
        return true;
    }

    public static SimpleContainer getInventory(ItemStack stack) {
        return new ItemBackedInventory(stack, SIZE){

            public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                return FlowerPouchItem.isValid(slot, stack);
            }
        };
    }

    public static boolean onPickupItem(ItemEntity entity, Player player) {
        ItemStack entityStack = entity.m_32055_();
        Block block = Block.m_49814_((Item)entityStack.m_41720_());
        if ((FlowerPouchItem.isMysticalFlower(entityStack) || block instanceof BotaniaDoubleFlowerBlock) && entityStack.m_41613_() > 0) {
            int slot;
            if (block instanceof BotaniaDoubleFlowerBlock) {
                BotaniaDoubleFlowerBlock flower = (BotaniaDoubleFlowerBlock)block;
                slot = 16 + flower.color.m_41060_();
            } else {
                slot = ((BotaniaFlowerBlock)block).color.m_41060_();
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                SimpleContainer bagInv;
                ItemStack existing;
                int newCount;
                int numPickedUp;
                ItemStack bag;
                if (i == player.m_150109_().f_35977_ || (bag = player.m_150109_().m_8020_(i)).m_41619_() || !bag.m_150930_(BotaniaItems.flowerBag) || (numPickedUp = (newCount = Math.min((existing = (bagInv = FlowerPouchItem.getInventory(bag)).m_8020_(slot)).m_41613_() + entityStack.m_41613_(), Math.min(existing.m_41741_(), bagInv.m_6893_()))) - existing.m_41613_()) <= 0) continue;
                if (existing.m_41619_()) {
                    bagInv.m_6836_(slot, entityStack.m_41620_(numPickedUp));
                } else {
                    existing.m_41769_(numPickedUp);
                    entityStack.m_41774_(numPickedUp);
                }
                EntityHelper.syncItem(entity);
                bagInv.m_6596_();
                player.m_7938_((Entity)entity, numPickedUp);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        if (!world.f_46443_) {
            final ItemStack stack = player.m_21120_(hand);
            XplatAbstractions.INSTANCE.openMenu((ServerPlayer)player, new MenuProvider(){

                public Component m_5446_() {
                    return stack.m_41786_();
                }

                public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                    return new FlowerPouchContainer(syncId, inv, stack);
                }
            }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)world.m_5776_());
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            if (!world.f_46443_) {
                Container container;
                if (!(tile instanceof Container)) {
                    return InteractionResult.FAIL;
                }
                Container tileInv = container = (Container)tile;
                SimpleContainer bagInv = FlowerPouchItem.getInventory(ctx.m_43722_());
                for (int i = 0; i < bagInv.m_6643_(); ++i) {
                    ItemStack flower = bagInv.m_8020_(i);
                    ItemStack rem = HopperBlockEntity.m_59326_((Container)bagInv, (Container)tileInv, (ItemStack)flower, (Direction)side);
                    bagInv.m_6836_(i, rem);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_142023_(@NotNull ItemEntity entity) {
        SimpleContainer container = FlowerPouchItem.getInventory(entity.m_32055_());
        Stream<ItemStack> stream = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((SimpleContainer)container).m_8020_(arg_0)).filter(s -> !s.m_41619_());
        ItemUtils.m_150952_((ItemEntity)entity, stream);
        container.m_6211_();
    }

    public boolean m_142207_(@NotNull ItemStack bag, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        return InventoryHelper.overrideStackedOnOther(FlowerPouchItem::getInventory, player.f_36096_ instanceof FlowerPouchContainer, bag, slot, clickAction, player);
    }

    public boolean m_142305_(@NotNull ItemStack bag, @NotNull ItemStack toInsert, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess cursorAccess) {
        return InventoryHelper.overrideOtherStackedOnMe(FlowerPouchItem::getInventory, player.f_36096_ instanceof FlowerPouchContainer, bag, toInsert, clickAction, cursorAccess);
    }
}

