/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.check.RegisterMod;
import com.natamus.collective_common_forge.config.CollectiveConfigHandler;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_forge.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldLoad(ServerLevel serverlevel) {
        entitiesToSpawn.put(serverlevel, new ArrayList());
        entitiesToRide.put(serverlevel, new WeakHashMap());
    }

    public static void onWorldTick(ServerLevel serverlevel) {
        if (!entitiesToSpawn.containsKey(serverlevel)) {
            entitiesToSpawn.put(serverlevel, new ArrayList());
        } else if (entitiesToSpawn.get(serverlevel).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverlevel).get(0);
            serverlevel.m_47205_(tospawn);
            if (!entitiesToRide.containsKey(serverlevel)) {
                entitiesToRide.put(serverlevel, new WeakHashMap());
            } else if (entitiesToRide.get(serverlevel).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverlevel).get(tospawn);
                rider.m_20329_(tospawn);
                entitiesToRide.get(serverlevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverlevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.m_129921_();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.m_6937_((Runnable)new TickTask(minecraftServer.m_129921_(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(Level world, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof Player) {
            RegisterMod.joinWorldProcess(world, (Player)entity);
        }
        if (entity.m_213877_()) {
            return true;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return true;
        }
        Set tags = entity.m_19880_();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.m_20049_("collective.checked");
        EntityType entitytype = entity.m_6095_();
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return true;
        }
        boolean isspawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        boolean ageable = entity instanceof AgeableMob;
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vec3 evec = entity.m_20182_();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue()) continue;
            Entity to = sam.totype.m_20615_(world);
            if (to == null) {
                return true;
            }
            to.m_6034_(evec.f_82479_, evec.f_82480_, evec.f_82481_);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.m_146762_(((AgeableMob)entity).m_146764_());
                to = am;
            }
            boolean ignoremainhand = false;
            if (sam.helditem != null && to instanceof LivingEntity && !(le = (LivingEntity)to).m_21205_().m_41720_().equals(sam.helditem)) {
                le.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.helditem, 1));
                ignoremainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.m_30651_(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoremainhand);
            }
            if (!(world instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverworld = (ServerLevel)world;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverworld, to, entity);
            } else {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            to.m_20049_("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverworld, to);
            return ride;
        }
        return true;
    }
}

