/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.common.util.collections.QueueDrainingIterator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkBuilder {
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private final Deque<WrappedTask> buildQueue = new ConcurrentLinkedDeque<WrappedTask>();
    private final Object jobNotifier = new Object();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<Thread> threads = new ArrayList<Thread>();
    private Level world;
    private BlockRenderPassManager renderPassManager;
    private final int limitThreads;
    private final ChunkVertexType vertexType;
    private final Queue<ChunkBuildResult> deferredResultQueue = new ConcurrentLinkedDeque<ChunkBuildResult>();
    private final ThreadLocal<ChunkBuildContext> localContexts = new ThreadLocal();

    public ChunkBuilder(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        this.limitThreads = ChunkBuilder.getThreadCount();
    }

    public int getSchedulingBudget() {
        return Math.max(0, this.limitThreads - this.buildQueue.size());
    }

    public void startWorkers() {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException("Threads are still alive while in the STOPPED state");
        }
        for (int i = 0; i < this.limitThreads; ++i) {
            ChunkBuildContext context = new ChunkBuildContext(this.world, this.vertexType, this.renderPassManager);
            WorkerRunnable worker = new WorkerRunnable(context);
            Thread thread = new Thread((Runnable)worker, "Chunk Render Task Executor #" + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", (Object)this.threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorkers() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("No threads are alive but the executor is in the RUNNING state");
        }
        LOGGER.info("Stopping worker threads");
        Iterator<Object> iterator = this.jobNotifier;
        synchronized (iterator) {
            this.jobNotifier.notifyAll();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
        for (WrappedTask job : this.buildQueue) {
            job.future.cancel(true);
        }
        while (!this.deferredResultQueue.isEmpty()) {
            this.deferredResultQueue.remove().delete();
        }
        this.buildQueue.clear();
        this.world = null;
        this.doneStealingTasks();
    }

    public void doneStealingTasks() {
        this.localContexts.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ChunkBuildResult> schedule(ChunkRenderBuildTask task) {
        if (!this.running.get()) {
            throw new IllegalStateException("Executor is stopped");
        }
        WrappedTask job = new WrappedTask(task);
        this.buildQueue.add(job);
        Object object = this.jobNotifier;
        synchronized (object) {
            this.jobNotifier.notify();
        }
        return job.future;
    }

    public boolean isBuildQueueEmpty() {
        return this.buildQueue.isEmpty();
    }

    public void init(ClientLevel world, BlockRenderPassManager renderPassManager) {
        if (world == null) {
            throw new NullPointerException("World is null");
        }
        this.stopWorkers();
        this.world = world;
        this.renderPassManager = renderPassManager;
        this.startWorkers();
    }

    private static int getOptimalThreadCount() {
        return Mth.m_14045_((int)Math.max(ChunkBuilder.getMaxThreadCount() / 3, ChunkBuilder.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getThreadCount() {
        int requested = SodiumClientMod.options().performance.chunkBuilderThreads;
        return requested == 0 ? ChunkBuilder.getOptimalThreadCount() : Math.min(requested, ChunkBuilder.getMaxThreadCount());
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public CompletableFuture<Void> scheduleDeferred(ChunkRenderBuildTask task) {
        return this.schedule(task).thenAccept(this.deferredResultQueue::add);
    }

    public Iterator<ChunkBuildResult> createDeferredBuildResultDrain() {
        return new QueueDrainingIterator<ChunkBuildResult>(this.deferredResultQueue);
    }

    public boolean stealTask() {
        WrappedTask task = this.getNextJob(false);
        if (task == null) {
            return false;
        }
        ChunkBuildContext context = this.localContexts.get();
        if (context == null) {
            context = new ChunkBuildContext(this.world, this.vertexType, this.renderPassManager);
            this.localContexts.set(context);
        }
        try {
            ChunkBuilder.processJob(task, context);
        }
        finally {
            context.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrappedTask getNextJob(boolean block) {
        WrappedTask job = this.buildQueue.poll();
        if (job == null && block) {
            Object object = this.jobNotifier;
            synchronized (object) {
                try {
                    this.jobNotifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return job;
    }

    private static void processJob(WrappedTask job, ChunkBuildContext context) {
        ChunkBuildResult result;
        if (job.isCancelled()) {
            return;
        }
        try {
            result = job.task.performBuild(context, job);
        }
        catch (Exception e) {
            job.future.completeExceptionally(e);
            e.printStackTrace();
            return;
        }
        if (result != null) {
            job.future.complete(result);
        } else if (!job.isCancelled()) {
            job.future.completeExceptionally(new RuntimeException("No result was produced by the task"));
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private final AtomicBoolean running;
        private final ChunkBuildContext context;

        public WorkerRunnable(ChunkBuildContext context) {
            this.running = ChunkBuilder.this.running;
            this.context = context;
        }

        @Override
        public void run() {
            while (this.running.get()) {
                WrappedTask job = ChunkBuilder.this.getNextJob(true);
                if (job == null) continue;
                try {
                    ChunkBuilder.processJob(job, this.context);
                }
                finally {
                    this.context.release();
                }
            }
        }
    }

    private static class WrappedTask
    implements CancellationSource {
        private final ChunkRenderBuildTask task;
        private final CompletableFuture<ChunkBuildResult> future;

        private WrappedTask(ChunkRenderBuildTask task) {
            this.task = task;
            this.future = new CompletableFuture();
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }
    }
}

