/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import fuzs.puzzleslib.capability.CapabilityController;
import fuzs.puzzleslib.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CSyncCapabilityMessage
implements Message<S2CSyncCapabilityMessage> {
    private ResourceLocation id;
    private int holderId;
    private CompoundTag tag;

    public S2CSyncCapabilityMessage() {
    }

    public S2CSyncCapabilityMessage(ResourceLocation id, Entity holder, CompoundTag tag) {
        this.id = id;
        this.holderId = holder.m_19879_();
        this.tag = tag;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.writeInt(this.holderId);
        buf.m_130079_(this.tag);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
        this.holderId = buf.readInt();
        this.tag = buf.m_130260_();
    }

    @Override
    public Message.MessageHandler<S2CSyncCapabilityMessage> makeHandler() {
        return new Message.MessageHandler<S2CSyncCapabilityMessage>(){

            @Override
            public void handle(S2CSyncCapabilityMessage message, Player player, Object gameInstance) {
                ClientLevel level = ((Minecraft)gameInstance).f_91073_;
                Entity holder = level.m_6815_(message.holderId);
                if (holder != null) {
                    CapabilityController.retrieve(message.id).orThrow(holder).read(message.tag);
                }
            }
        };
    }
}

