/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TurretChemBlockEntity
extends TurretBlockEntity<TurretChemBlockEntity> {
    public static final int TANK_VOLUME = 4000;
    public FluidTank tank = new FluidTank(4000);
    public boolean ignite = false;
    private final ResettableCapability<IFluidHandler> tankCap = this.registerCapability(this.tank);

    public TurretChemBlockEntity(BlockEntityType<TurretChemBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected double getRange() {
        return 8.0;
    }

    @Override
    protected boolean canActivate() {
        return this.tank.getFluidAmount() > 0 && this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.turret_chem_consumption.get();
    }

    @Override
    protected int getChargeupTicks() {
        return 10;
    }

    @Override
    protected int getActiveTicks() {
        return 1;
    }

    @Override
    protected boolean loopActivation() {
        return true;
    }

    @Override
    protected void activate() {
        FluidStack fs = this.tank.getFluid().copy();
        if (!fs.isEmpty()) {
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            int energy = (Integer)IEServerConfig.MACHINES.turret_chem_consumption.get();
            if (consumed <= fs.getAmount() && this.energyStorage.extractEnergy(energy, true) >= energy) {
                this.tank.drain(consumed, IFluidHandler.FluidAction.EXECUTE);
                this.energyStorage.extractEnergy(energy, false);
                Vec3 v = this.getGunToTargetVec(this.target).m_82541_();
                int split = 8;
                boolean isGas = fs.getFluid().m_205067_(Tags.Fluids.GASEOUS);
                float scatter = isGas ? 0.15f : 0.05f;
                float range = isGas ? 0.5f : 1.0f;
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && this.ignite;
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.m_82520_(ApiUtils.RANDOM.nextGaussian() * (double)scatter, ApiUtils.RANDOM.nextGaussian() * (double)scatter, ApiUtils.RANDOM.nextGaussian() * (double)scatter);
                    Vec3 throwerPos = this.getGunPosition();
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(this.f_58857_, throwerPos.f_82479_ + v.f_82479_ * 0.875, throwerPos.f_82480_ + v.f_82480_ * 0.875, throwerPos.f_82481_ + v.f_82481_ * 0.875, fs);
                    chem.m_20256_(vecDir.m_82490_((double)range));
                    if (ignite) {
                        chem.m_20254_(10);
                    }
                    if (this.f_58857_.f_46443_) continue;
                    this.f_58857_.m_7967_((Entity)chem);
                }
                if (this.tick % 4 == 0) {
                    if (ignite) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)IESounds.sprayFire.get(), SoundSource.BLOCKS, 0.5f, 1.5f);
                    } else {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)IESounds.spray.get(), SoundSource.BLOCKS, 0.5f, 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.ignite = nbt.m_128471_("ignite");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("ignite", this.ignite);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!(this.isDummy() || capability != ForgeCapabilities.FLUID_HANDLER || facing != null && facing != Direction.DOWN && facing != this.getFacing().m_122424_())) {
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IEMenuTypes.BEContainer<TurretChemBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CHEM_TURRET;
    }
}

