/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.client.models.obj.callback.block.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RazorWireCallbacks
implements BlockCallback<Key> {
    public static final RazorWireCallbacks INSTANCE = new RazorWireCallbacks();
    private static final Key INVALID = new Key(false, false, true, true);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof RazorWireBlockEntity)) {
            return this.getDefaultKey();
        }
        RazorWireBlockEntity razorWire = (RazorWireBlockEntity)blockEntity;
        return new Key(razorWire.isStacked(), razorWire.isOnGround(), razorWire.renderWall(true), razorWire.renderWall(false));
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean shouldRenderGroup(Key object, String group, RenderType layer) {
        if (group == null) {
            return false;
        }
        if (!object.stacked() && !object.onGround()) {
            return !group.startsWith("wood");
        }
        if (group.startsWith("wood") && group.endsWith("inverted") != object.stacked()) {
            return false;
        }
        if (group.startsWith("wood_left")) {
            return object.leftWall();
        }
        if ("wire_left".equals(group) || "barbs_left".equals(group)) {
            return !object.leftWall();
        }
        if (group.startsWith("wood_right")) {
            return object.rightWall();
        }
        if ("wire_right".equals(group) || "barbs_right".equals(group)) {
            return !object.rightWall();
        }
        return true;
    }

    public record Key(boolean stacked, boolean onGround, boolean leftWall, boolean rightWall) {
    }
}

