/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class PacketSummonFamiliar {
    ResourceLocation familiarID;
    int entityID;

    public PacketSummonFamiliar(ResourceLocation id, int entityID) {
        this.familiarID = id;
        this.entityID = entityID;
    }

    public PacketSummonFamiliar(FriendlyByteBuf buf) {
        this.familiarID = buf.m_130281_();
        this.entityID = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.familiarID);
        buf.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                IPlayerCap cap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender()).orElse(null);
                if (cap == null) {
                    return;
                }
                Entity owner = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_6815_(this.entityID);
                if (owner instanceof LivingEntity && ((LivingEntity)owner).m_21023_((MobEffect)ModPotions.FAMILIAR_SICKNESS_EFFECT.get())) {
                    PortUtil.sendMessage(owner, (Component)Component.m_237115_((String)"ars_nouveau.familiar.sickness"));
                    return;
                }
                IFamiliar familiarEntity = cap.getFamiliarData(this.familiarID).getEntity(((NetworkEvent.Context)ctx.get()).getSender().f_19853_);
                familiarEntity.setOwnerID(owner.m_20148_());
                familiarEntity.getThisEntity().m_6034_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                FamiliarSummonEvent summonEvent = new FamiliarSummonEvent(familiarEntity.getThisEntity(), owner);
                MinecraftForge.EVENT_BUS.post((Event)summonEvent);
                if (!summonEvent.isCanceled()) {
                    owner.f_19853_.m_7967_(familiarEntity.getThisEntity());
                    ParticleUtil.spawnPoof((ServerLevel)owner.f_19853_, familiarEntity.getThisEntity().m_20183_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

