/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.nbt.ItemstackData;
import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.client.renderer.item.FlaskCannonRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.items.AlchemistsCrown;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetLauncher;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public abstract class FlaskCannon
extends ModItem
implements IRadialProvider,
IAnimatable {
    public AnimationFactory factory = GeckoLibUtil.createFactory(this);

    public FlaskCannon(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pLevel.f_46443_) {
            return;
        }
        if (!(pEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)pEntity;
        PotionLauncherData potionLauncherData = new PotionLauncherData(pStack);
        int lastSlot = potionLauncherData.lastSlot;
        if (lastSlot < 0 || lastSlot >= player.f_36093_.m_6643_()) {
            return;
        }
        ItemStack item = player.f_36093_.m_8020_(lastSlot);
        if (!(item.m_41720_() instanceof PotionFlask) && !(item.m_41720_() instanceof PotionItem)) {
            potionLauncherData.setAmountLeft(0);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        PotionLauncherData potionLauncherData = new PotionLauncherData(itemstack);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        PotionData potionData = potionLauncherData.getPotionDataFromSlot(pPlayer);
        if (potionData.isEmpty()) {
            PortUtil.sendMessage((Entity)pPlayer, (Component)Component.m_237115_((String)"ars_nouveau.flask_cannon.no_potion"));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
        }
        ThrownPotion thrownpotion = new ThrownPotion(pLevel, (LivingEntity)pPlayer);
        ItemStack stckToThrow = this.getThrownStack(pLevel, pPlayer, pHand, itemstack);
        if (new PotionData(stckToThrow).isEmpty()) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        thrownpotion.m_37446_(stckToThrow);
        thrownpotion.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), -20.0f, 0.5f, 1.0f);
        pLevel.m_7967_((Entity)thrownpotion);
        pPlayer.m_36335_().m_41524_((Item)this, 10);
        potionLauncherData.setLastDataForRender(new PotionData(stckToThrow));
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)itemstack);
    }

    public abstract ItemStack getThrownStack(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int forKey() {
        return ModKeyBindings.OPEN_RADIAL_HUD.getKey().m_84873_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        ArrayList slots = new ArrayList();
        for (int i = 0; i < player.f_36093_.m_6643_() && slots.size() < 9; ++i) {
            ItemStack item = player.f_36093_.m_8020_(i);
            PotionData potionData = new PotionData(item);
            if (potionData.isEmpty() || item.m_41720_() instanceof ArrowItem) continue;
            slots.add(new RadialMenuSlot<AlchemistsCrown.SlotData>(item.m_41786_().getString(), new AlchemistsCrown.SlotData(i, item)));
        }
        if (slots.isEmpty()) {
            PortUtil.sendMessage((Entity)Minecraft.m_91087_().f_91074_, (Component)Component.m_237115_((String)"ars_nouveau.alchemists_crown.no_flasks"));
            return;
        }
        Minecraft.m_91087_().m_91152_(new GuiRadialMenu<AlchemistsCrown.SlotData>(new RadialMenu<AlchemistsCrown.SlotData>(index -> Networking.INSTANCE.sendToServer((Object)new PacketSetLauncher(((AlchemistsCrown.SlotData)((RadialMenuSlot)slots.get(index)).primarySlotIcon()).getSlot())), slots, (slotData, posestack, positionx, posy, size, transparent) -> RenderUtils.drawItemAsIcon(slotData.getStack(), posestack, positionx, posy, size, transparent), 3)));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void registerControllers(AnimationData data) {
    }

    public static class PotionLauncherData
    extends ItemstackData {
        private PotionData lastDataForRender;
        private int lastSlot;
        public int amountLeft;

        public PotionLauncherData(ItemStack stack) {
            super(stack);
            CompoundTag tag = this.getItemTag(stack);
            if (tag == null) {
                return;
            }
            this.lastDataForRender = PotionData.fromTag(tag.m_128469_("lastDataForRender"));
            this.lastSlot = tag.m_128451_("lastSlot");
            this.amountLeft = tag.m_128451_("amountLeft");
        }

        public PotionData getPotionDataFromSlot(Player player) {
            if (this.lastSlot < 0 || this.lastSlot >= player.f_36093_.m_6643_()) {
                return new PotionData();
            }
            ItemStack stack = player.f_36093_.m_8020_(this.lastSlot);
            return new PotionData(stack);
        }

        public PotionData expendPotion(Player player) {
            if (this.lastSlot >= player.f_36093_.m_6643_()) {
                return new PotionData();
            }
            ItemStack item = player.f_36093_.m_8020_(this.lastSlot);
            if (item.m_41720_() instanceof PotionFlask) {
                PotionFlask.FlaskData flaskData = new PotionFlask.FlaskData(item);
                if (flaskData.getCount() <= 0 || flaskData.getPotion().isEmpty()) {
                    return new PotionData();
                }
                PotionData data = flaskData.getPotion().clone();
                flaskData.setCount(flaskData.getCount() - 1);
                this.setAmountLeft(flaskData.getCount());
                return data;
            }
            if (item.m_41720_() instanceof PotionItem) {
                PotionData data = new PotionData(item).clone();
                if (data.isEmpty()) {
                    return new PotionData();
                }
                item.m_41774_(1);
                player.f_36093_.m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                this.setAmountLeft(0);
                return data;
            }
            return new PotionData();
        }

        public void setAmountLeft(int amount) {
            this.amountLeft = amount;
            this.writeItem();
        }

        public void setLastSlot(int lastSlot) {
            this.lastSlot = lastSlot;
            this.writeItem();
        }

        public void setLastDataForRender(PotionData lastDataForRender) {
            this.lastDataForRender = lastDataForRender;
            this.writeItem();
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128405_("lastSlot", this.lastSlot);
            tag.m_128365_("lastDataForRender", (Tag)this.lastDataForRender.toTag());
            tag.m_128405_("amountLeft", this.amountLeft);
        }

        public PotionData getLastDataForRender() {
            return this.lastDataForRender;
        }

        @Override
        public String getTagString() {
            return "potion_launcher";
        }
    }

    public static class LingeringLauncher
    extends FlaskCannon {
        public LingeringLauncher(Item.Properties properties) {
            super(properties);
        }

        @Override
        public ItemStack getThrownStack(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack launcherStack) {
            PotionLauncherData data = new PotionLauncherData(launcherStack);
            ItemStack splashStack = new ItemStack((ItemLike)Items.f_42739_);
            PotionData potionData = data.expendPotion(pPlayer);
            PotionUtils.m_43549_((ItemStack)splashStack, (Potion)potionData.getPotion());
            PotionUtils.m_43552_((ItemStack)splashStack, potionData.getCustomEffects());
            return splashStack;
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){
                private final BlockEntityWithoutLevelRenderer renderer = new FlaskCannonRenderer(new GenericModel("lingering_flask_cannon", "items").withEmptyAnim());

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return this.renderer;
                }
            });
        }
    }

    public static class SplashLauncher
    extends FlaskCannon {
        public SplashLauncher(Item.Properties properties) {
            super(properties);
        }

        @Override
        public ItemStack getThrownStack(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack launcherStack) {
            PotionLauncherData data = new PotionLauncherData(launcherStack);
            ItemStack splashStack = new ItemStack((ItemLike)Items.f_42736_);
            PotionData potionData = data.expendPotion(pPlayer);
            PotionUtils.m_43549_((ItemStack)splashStack, (Potion)potionData.getPotion());
            PotionUtils.m_43552_((ItemStack)splashStack, potionData.getCustomEffects());
            return splashStack;
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){
                private final BlockEntityWithoutLevelRenderer renderer = new FlaskCannonRenderer(new GenericModel("splash_flask_cannon", "items").withEmptyAnim());

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return this.renderer;
                }
            });
        }
    }
}

