/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.nbt.ItemstackData;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.util.ColorPos;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DominionWand
extends ModItem {
    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pIsSelected || pLevel.f_46443_ || pLevel.m_46467_() % 5L != 0L) {
            return;
        }
        DominionData data = new DominionData(pStack);
        BlockPos pos = data.storedPos;
        if (pos != null) {
            BlockEntity blockEntity = pLevel.m_7702_(pos);
            if (blockEntity instanceof IWandable) {
                IWandable wandable = (IWandable)blockEntity;
                Networking.sendToPlayer(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
            }
            return;
        }
        Entity entity = data.getEntity(pLevel);
        if (entity instanceof IWandable) {
            IWandable wandable = (IWandable)entity;
            Networking.sendToPlayer(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
        }
    }

    public InteractionResult m_6880_(ItemStack doNotUseStack, Player playerEntity, LivingEntity target, InteractionHand hand) {
        IWandable wandable;
        BlockEntity blockEntity;
        if (playerEntity.f_19853_.f_46443_ || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerEntity.m_21120_(hand);
        DominionData data = new DominionData(stack);
        if (playerEntity.m_6144_() && target instanceof IWandable) {
            IWandable wandable2 = (IWandable)target;
            wandable2.onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return InteractionResult.SUCCESS;
        }
        if (!data.hasStoredData()) {
            data.setStoredEntityID(target.m_19879_());
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.stored_entity"));
            return InteractionResult.SUCCESS;
        }
        Level world = playerEntity.m_20193_();
        if (data.getStoredPos() != null && (blockEntity = world.m_7702_(data.getStoredPos())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(data.getStoredPos(), target, playerEntity);
        }
        if (target instanceof IWandable) {
            wandable = (IWandable)target;
            wandable.onFinishedConnectionLast(data.getStoredPos(), target, playerEntity);
            this.clear(stack, playerEntity);
        }
        if (playerEntity.m_6144_() && target instanceof IDecoratable) {
            IDecoratable coolBoy = (IDecoratable)target;
            coolBoy.setCosmeticItem(ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void clear(ItemStack stack, Player player) {
        DominionData data = new DominionData(stack);
        data.setStoredPos(null);
        data.setStoredEntityID(-1);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IWandable wandable;
        BlockEntity blockEntity;
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return super.m_6225_(context);
        }
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerEntity = context.m_43723_();
        ItemStack stack = context.m_43722_();
        DominionData data = new DominionData(stack);
        if (playerEntity.m_6144_() && (blockEntity = world.m_7702_(pos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            if (!data.hasStoredData()) {
                wandable.onWanded(playerEntity);
                this.clear(stack, playerEntity);
                return InteractionResult.CONSUME;
            }
        }
        if (!data.hasStoredData()) {
            data.setStoredPos(pos.m_7949_());
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.position_set"));
            return InteractionResult.SUCCESS;
        }
        if (data.getStoredPos() != null && (blockEntity = world.m_7702_(data.getStoredPos())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, (LivingEntity)world.m_6815_(data.getStoredEntityID()), playerEntity);
        }
        if ((blockEntity = world.m_7702_(pos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionLast(data.getStoredPos(), (LivingEntity)world.m_6815_(data.getStoredEntityID()), playerEntity);
        }
        if (data.getStoredEntityID() != -1 && (blockEntity = world.m_6815_(data.getStoredEntityID())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, null, playerEntity);
        }
        this.clear(stack, playerEntity);
        return super.m_6225_(context);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        DominionData data = new DominionData(stack);
        if (data.getStoredEntityID() == -1) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.no_entity"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.entity_stored"));
        }
        if (data.getStoredPos() == null) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.dominion_wand.no_location"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.dominion_wand.position_stored", (Object[])new Object[]{DominionWand.getPosString(data.getStoredPos())}));
        }
    }

    public static String getPosString(BlockPos pos) {
        return Component.m_237110_((String)"ars_nouveau.position", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).getString();
    }

    public static class DominionData
    extends ItemstackData {
        private BlockPos storedPos;
        private int storedEntityID;

        public DominionData(ItemStack stack) {
            super(stack);
            CompoundTag tag = this.getItemTag(stack);
            if (tag == null) {
                return;
            }
            this.storedPos = NBTUtil.getNullablePos(tag, "stored");
            this.storedEntityID = tag.m_128451_("entityID");
        }

        public boolean hasStoredData() {
            return this.getStoredPos() != null || this.getStoredEntityID() != -1;
        }

        @Nullable
        public BlockPos getStoredPos() {
            return this.storedPos == BlockPos.f_121853_ || this.storedPos == null ? null : this.storedPos.m_7949_();
        }

        public int getStoredEntityID() {
            return this.storedEntityID == 0 ? -1 : this.storedEntityID;
        }

        @Nullable
        public Entity getEntity(Level world) {
            return world.m_6815_(this.storedEntityID);
        }

        public void setStoredPos(@Nullable BlockPos pos) {
            this.storedPos = pos;
            this.writeItem();
        }

        public void setStoredEntityID(int id) {
            this.storedEntityID = id;
            this.writeItem();
        }

        @Override
        public String getTagString() {
            return "an_dominion_wand";
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            if (this.storedPos != null) {
                NBTUtil.storeBlockPos(tag, "stored", this.storedPos);
            }
            tag.m_128405_("entityID", this.storedEntityID);
        }
    }
}

