/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ManaUtil {
    public static int getPlayerDiscounts(LivingEntity e) {
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack item = items.getStackInSlot(i);
                Item patt1245$temp = item.m_41720_();
                if (!(patt1245$temp instanceof IManaEquipment)) continue;
                IManaEquipment discountItem = (IManaEquipment)patt1245$temp;
                discounts.addAndGet(discountItem.getManaDiscount(item));
            }
        });
        return discounts.get();
    }

    public static double getCurrentMana(LivingEntity e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana(e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        return mana.getCurrentMana();
    }

    public static int getMaxMana(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0;
        }
        int max = (Integer)ServerConfig.INIT_MAX_MANA.get();
        max = (int)((double)max + PerkUtil.perkValue((LivingEntity)e, (Attribute)PerkAttributes.FLAT_MANA_BONUS.get()));
        for (ItemStack i : e.m_20158_()) {
            max += (Integer)ServerConfig.MANA_BOOST_BONUS.get() * i.getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.get());
        }
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus();
        max += numGlyphs * (Integer)ServerConfig.GLYPH_MAX_BONUS.get();
        max += tier * (Integer)ServerConfig.TIER_MAX_BONUS.get();
        max = (int)((double)max * PerkUtil.perkValue((LivingEntity)e, (Attribute)PerkAttributes.MAX_MANA_BONUS.get()));
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max);
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        return max;
    }

    public static double getManaRegen(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = ((Integer)ServerConfig.INIT_MANA_REGEN.get()).intValue();
        if (e.m_21051_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()) != null) {
            regen += e.m_21133_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get());
        }
        for (ItemStack i : e.m_20158_()) {
            regen += (double)((Integer)ServerConfig.MANA_REGEN_ENCHANT_BONUS.get() * i.getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.get()));
        }
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus();
        regen += numGlyphs * (Double)ServerConfig.GLYPH_REGEN_BONUS.get();
        regen += (double)(tier * (Integer)ServerConfig.TIER_REGEN_BONUS.get());
        if (e.m_21023_((MobEffect)ModPotions.MANA_REGEN_EFFECT.get())) {
            regen += (double)((Integer)ServerConfig.MANA_REGEN_POTION.get() * (1 + e.m_21124_((MobEffect)ModPotions.MANA_REGEN_EFFECT.get()).m_19564_()));
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }
}

