/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells_x_origins;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class OriginRequirement
extends Requirement {
    protected ResourceLocation origin;

    public OriginRequirement(IRequirementType<?> type) {
        super(type);
    }

    public OriginRequirement(IRequirementType<?> type, ResourceLocation origin) {
        super(type);
        this.origin = origin;
    }

    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess containerLevelAccess) {
        AtomicBoolean ret = new AtomicBoolean(false);
        IOriginContainer.get((Entity)spellProgressionHolder.getPlayer()).ifPresent(container -> container.getOrigins().forEach((layerKey, originKey) -> {
            if (originKey != null && originKey.m_135782_().equals((Object)this.origin)) {
                ret.set(true);
            }
        }));
        return ret.get();
    }

    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess containerLevelAccess) {
        return Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{Component.m_237115_((String)("origin." + this.origin.m_135827_() + "." + this.origin.m_135815_() + ".name"))});
    }

    public void writeToJson(JsonObject jsonObject) {
        jsonObject.addProperty("origin", this.origin.toString());
    }

    public void readFromJson(JsonObject jsonObject) {
        this.origin = new ResourceLocation(SpellsFileUtil.jsonString((JsonObject)jsonObject, (String)"origin"));
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.origin);
    }

    public void readFromBuf(FriendlyByteBuf buf) {
        this.origin = buf.m_130281_();
    }
}

