/*
 * Decompiled with CFR 0.152.
 */
package squeek.wthitharvestability.helpers;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import squeek.wthitharvestability.helpers.ToolType;

public class BlockHelper {
    public static ToolType getEffectiveToolOf(Level world, BlockPos blockPos, BlockState state) {
        ToolType effectiveTool = null;
        float hardness = state.m_60800_((BlockGetter)world, blockPos);
        if (hardness > 0.0f) {
            for (Map.Entry<TagKey<Block>, ToolType> testToolEntry : ToolType.MAP.entrySet()) {
                ItemStack testTool = testToolEntry.getValue().woodenStack();
                if (testTool == null || testTool.m_41619_() || !(testTool.m_41720_() instanceof TieredItem) || !(testTool.m_41691_(state) >= Tiers.WOOD.m_6624_())) continue;
                effectiveTool = testToolEntry.getValue();
                break;
            }
        }
        return effectiveTool;
    }

    public static boolean isBlockUnbreakable(Level world, BlockPos blockPos, BlockState state) {
        return state.m_60800_((BlockGetter)world, blockPos) == -1.0f;
    }

    public static boolean isAdventureModeAndBlockIsUnbreakable(Player player, BlockPos pos) {
        ClientPacketListener netHandler = Minecraft.m_91087_().m_91403_();
        if (netHandler == null) {
            return false;
        }
        PlayerInfo networkplayerinfo = netHandler.m_104949_(player.m_36316_().getId());
        GameType gameType = networkplayerinfo.m_105325_();
        if (gameType != GameType.ADVENTURE) {
            return false;
        }
        if (player.m_36326_()) {
            return false;
        }
        ItemStack heldItem = player.m_21205_();
        Level world = player.f_19853_;
        return gameType == GameType.SPECTATOR || heldItem.m_41619_() || !heldItem.m_204128_(world.m_5962_().m_175515_(Registry.f_122901_), new BlockInWorld((LevelReader)world, pos, false));
    }

    public static boolean canHarvestBlock(BlockState state, Player player) {
        if (!state.m_60834_()) {
            return true;
        }
        return player.m_36298_(state);
    }
}

