/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
extends ConfigListWidget.Entry {
    protected final Consumer<T> save;
    protected final String translationKey;
    @Nullable
    protected final T defaultValue;
    private final Component title;
    private final String description;
    private final Button resetButton;
    @Nullable
    private String disabledReason = null;
    @Nullable
    private String id;
    private T value;
    private int x;

    public ConfigValue(String translationKey, T value, @Nullable T defaultValue, Consumer<T> save) {
        this.translationKey = translationKey;
        this.title = Component.m_237115_((String)translationKey);
        this.description = translationKey + "_desc";
        this.value = value;
        this.save = save;
        this.defaultValue = defaultValue;
        this.resetButton = defaultValue == null ? null : new Button(0, 0, 40, 20, (Component)Component.m_237115_((String)"controls.reset"), button -> this.resetValue());
    }

    @Override
    public final void m_6311_(@NotNull PoseStack matrices, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        super.m_6311_(matrices, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        Component title = !this.isDisabled() ? this.title : this.title.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.GRAY});
        Font font = this.client.f_91062_;
        float f = rowLeft;
        float f2 = rowTop;
        Objects.requireNonNull(this.client.f_91062_);
        font.m_92763_(matrices, title, f, f2 + (float)(height - 9) / 2.0f, 0xFFFFFF);
        int w = width;
        if (this.resetButton != null) {
            w -= this.resetButton.m_5711_() + 2;
            this.resetButton.f_93620_ = rowLeft + width - this.resetButton.m_5711_();
            this.resetButton.f_93621_ = rowTop + (height - this.resetButton.m_93694_()) / 2;
            this.resetButton.f_93623_ = !this.isDisabled() && !this.getValue().equals(this.defaultValue);
            this.resetButton.m_6305_(matrices, mouseX, mouseY, deltaTime);
        }
        this.drawValue(matrices, w, height, rowLeft, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void renderTooltip(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        boolean hasDescTl = I18n.m_118936_((String)this.getDescription());
        if (this.id != null || hasDescTl || this.isDisabled()) {
            String title = this.getTitle().getString();
            ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{Component.m_237113_((String)title).m_7532_()});
            if (hasDescTl) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.getDescription()).m_130940_(ChatFormatting.GRAY), 250));
            }
            if (this.isDisabled()) {
                tooltip.addAll(this.client.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.disabledReason).m_130940_(ChatFormatting.RED), 250));
            }
            if (this.id != null) {
                tooltip.add(Component.m_237113_((String)this.id).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            }
            screen.m_96617_(matrices, (List)tooltip, mouseX, mouseY);
        }
    }

    @Override
    public void addToScreen(ConfigScreen screen) {
        Button resetButton;
        GuiEventListener element = this.getListener();
        if (element != null) {
            screen.addListener(element);
        }
        if ((resetButton = this.getResetButton()) != null) {
            screen.addListener((GuiEventListener)resetButton);
        }
    }

    public void save() {
        if (!this.isDisabled()) {
            this.save.accept(this.getValue());
        }
    }

    public GuiEventListener getListener() {
        return null;
    }

    @Nullable
    public Button getResetButton() {
        return this.resetButton;
    }

    public Component getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getX() {
        return this.x;
    }

    public final T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    protected void resetValue() {
        this.setValue(this.defaultValue);
    }

    public void disable(String reason) {
        this.disabledReason = reason;
    }

    public final boolean isDisabled() {
        return this.disabledReason != null;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    protected abstract void drawValue(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

