/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.config.Theme;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

class ThemeEditorScreen
extends ConfigScreen {
    private final WailaConfigScreen parent;
    private final Theme theme;
    private final boolean edit;
    private final TooltipRenderer.State previewState;
    private InputValue<String> idVal;
    private InputValue<Integer> bgColorVal;
    private InputValue<Integer> gradStartVal;
    private InputValue<Integer> gradEndVal;
    private InputValue<Integer> textColorVal;

    public ThemeEditorScreen(WailaConfigScreen parent, Theme theme, boolean edit) {
        super(parent, CommonComponents.f_237098_, () -> {}, () -> {});
        this.parent = parent;
        this.theme = theme;
        this.edit = edit;
        this.previewState = new PreviewTooltipRendererState();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.parent.buildPreview(this.previewState);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget option = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 76, this.f_96544_ - 32, 26, () -> {});
        this.idVal = new InputValue<String>("config.waila.overlay_theme_editor.id", this.edit ? this.theme.getId().toString() : "", null, val -> {}, InputValue.IDENTIFIER);
        if (!this.edit) {
            option.add(this.idVal);
        }
        this.bgColorVal = new IntInputValue("config.waila.overlay_theme_editor.background_color", this.theme.getBackgroundColor(), null, val -> {}, IntFormat.RGB_HEX);
        this.gradStartVal = new IntInputValue("config.waila.overlay_theme_editor.gradient_start", this.theme.getGradientStart(), null, val -> {}, IntFormat.RGB_HEX);
        this.gradEndVal = new IntInputValue("config.waila.overlay_theme_editor.gradient_end", this.theme.getGradientEnd(), null, val -> {}, IntFormat.RGB_HEX);
        this.textColorVal = new IntInputValue("config.waila.overlay_theme_editor.text_color", this.theme.getFontColor(), null, val -> {}, IntFormat.RGB_HEX);
        option.with(this.bgColorVal).with(this.gradStartVal).with(this.gradEndVal).with(this.textColorVal);
        if (this.edit && !this.theme.getId().m_135827_().equals("waila")) {
            option.add(new ButtonEntry("config.waila.overlay_theme_editor.delete", 100, 20, button -> this.f_96541_.m_91152_((Screen)new ConfirmScreen(delete -> {
                if (delete) {
                    this.parent.removeTheme(this.theme.getId());
                    this.f_96541_.m_91152_((Screen)this.parent);
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237110_((String)"config.waila.overlay_theme_editor.delete_prompt", (Object[])new Object[]{this.theme.getId()}), CommonComponents.f_237098_))));
        }
        return option;
    }

    @Override
    protected void renderForeground(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        TooltipRenderer.render(matrices, partialTicks);
    }

    @Override
    public void m_7379_() {
        if (this.cancelled) {
            TooltipRenderer.resetState();
            super.m_7379_();
            return;
        }
        if (((String)this.idVal.getValue()).isBlank()) {
            this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"config.waila.missing_input"), (Component)Component.m_237115_((String)"config.waila.overlay_theme_editor.id_empty")));
        } else {
            ResourceLocation id = new ResourceLocation((String)this.idVal.getValue());
            if (id.m_135827_().equals("minecraft") && !((String)this.idVal.getValue()).startsWith("minecraft:")) {
                id = new ResourceLocation("custom", id.m_135815_());
            }
            this.parent.addTheme(new Theme(id, (Integer)this.bgColorVal.getValue(), (Integer)this.gradStartVal.getValue(), (Integer)this.gradEndVal.getValue(), (Integer)this.textColorVal.getValue()));
            TooltipRenderer.resetState();
            super.m_7379_();
        }
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public float getScale() {
            return 2.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 1;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public int getBg() {
            return -16777216 + (Integer)ThemeEditorScreen.this.bgColorVal.getValue();
        }

        @Override
        public int getGradStart() {
            return -16777216 + (Integer)ThemeEditorScreen.this.gradStartVal.getValue();
        }

        @Override
        public int getGradEnd() {
            return -16777216 + (Integer)ThemeEditorScreen.this.gradEndVal.getValue();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }

        @Override
        public int getFontColor() {
            return (Integer)ThemeEditorScreen.this.textColorVal.getValue();
        }
    }
}

