/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemDescription;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class KineticBlock
extends Block
implements IRotate {
    protected static final ItemDescription.Palette color = ItemDescription.Palette.Red;

    public KineticBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof KineticTileEntity) {
            KineticTileEntity kineticTileEntity = (KineticTileEntity)tileEntity;
            kineticTileEntity.preventSpeedUpdate = 0;
            if (oldState.m_60734_() != state.m_60734_()) {
                return;
            }
            if (state.m_155947_() != oldState.m_155947_()) {
                return;
            }
            if (!this.areStatesKineticallyEquivalent(oldState, state)) {
                return;
            }
            kineticTileEntity.preventSpeedUpdate = 2;
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        ITE.onRemove(pState, pLevel, pPos, pNewState);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            return false;
        }
        return this.getRotationAxis(newState) == this.getRotationAxis(oldState);
    }

    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return;
        }
        KineticTileEntity kte = (KineticTileEntity)tileEntity;
        if (kte.preventSpeedUpdate > 0) {
            return;
        }
        kte.warnOfMovement();
        kte.clearKineticInformation();
        kte.updateSpeed = true;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        AdvancementBehaviour.setPlacedBy(worldIn, pos, placer);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return;
        }
        KineticTileEntity kte = (KineticTileEntity)tileEntity;
        kte.effects.queueRotationIndicators();
    }

    public float getParticleTargetRadius() {
        return 0.65f;
    }

    public float getParticleInitialRadius() {
        return 0.75f;
    }
}

