/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEMultiblockBlock;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlockEntity;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.ManualItem;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageOpenManual;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.register.IEStats;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SimpleCapProvider;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.VanillaFurnaceHeater;
import blusunrize.immersiveengineering.common.wires.GlobalNetProvider;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;

public class EventHandler {
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static final Queue<Runnable> SERVER_TASKS = new ArrayDeque<Runnable>();
    public static Map<UUID, CrusherBlockEntity> crusherMap = new HashMap<UUID, CrusherBlockEntity>();

    @SubscribeEvent
    public void onLoad(LevelEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onCapabilitiesAttachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof AbstractMinecart) {
            event.addCapability(new ResourceLocation("immersiveengineering:shader"), (ICapabilityProvider)new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "minecart")));
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("immersiveengineering", "skyhook_data"), (ICapabilityProvider)new CapabilitySkyhookData.SimpleSkyhookProvider());
        }
    }

    @SubscribeEvent
    public void onCapabilitiesAttachWorld(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(ImmersiveEngineering.rl("wire_network"), (ICapabilityProvider)new GlobalNetProvider((Level)event.getObject()));
    }

    @SubscribeEvent
    public void onCapabilitiesAttachBlockEntity(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)object;
            event.addCapability(ImmersiveEngineering.rl("vanilla_furnace_heater"), new SimpleCapProvider<VanillaFurnaceHeater>(() -> ExternalHeaterHandler.CAPABILITY, new VanillaFurnaceHeater(furnace)));
        }
    }

    @SubscribeEvent
    public void onMinecartInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        AbstractMinecart cart = (AbstractMinecart)entity;
        if (stack.m_41720_() instanceof IShaderItem) {
            CapabilityShader.ShaderWrapper wrapper = CapabilityUtils.getCapability((ICapabilityProvider)cart, CapabilityShader.SHADER_CAPABILITY);
            if (wrapper != null && !event.getLevel().f_46443_) {
                wrapper.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> cart), (Object)new MessageMinecartShaderSync((Entity)cart, wrapper));
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof IShaderItem) {
            ResourceLocation shader = ((IShaderItem)stack.m_41720_()).getShaderName(stack);
            ShaderRegistry.markShaderReceived(player.m_20148_(), shader);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.level.f_46443_) {
            GlobalWireNetwork.getNetwork(event.level).update(event.level);
            int numToRun = SERVER_TASKS.size();
            for (int i = 0; i < numToRun; ++i) {
                Runnable next = SERVER_TASKS.poll();
                if (next == null) continue;
                next.run();
            }
        }
        if (event.phase == TickEvent.Phase.START && !currentExplosions.isEmpty()) {
            Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
            while (itExplosion.hasNext()) {
                IEExplosion ex = itExplosion.next();
                ex.doExplosionTick();
                if (!ex.isExplosionFinished) continue;
                itExplosion.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        CrusherBlockEntity crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().m_19385_()) && (crusher = crusherMap.get(event.getEntity().m_20148_())) != null) {
            for (ItemEntity item : event.getDrops()) {
                if (item == null || item.m_32055_().m_41619_()) continue;
                crusher.doProcessOutput(item.m_32055_());
            }
            crusherMap.remove(event.getEntity().m_20148_());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            boolean isBoss = event.getEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES);
            if (!isBoss || event.getEntity().m_6095_().m_204039_(IETags.shaderbagBlacklist)) {
                return;
            }
            ItemStack bag = new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.EPIC));
            event.getDrops().add(new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        Player player;
        ItemStack activeStack;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(activeStack = (player = (Player)livingEntity).m_21211_()).m_41619_() && activeStack.m_41720_() instanceof IEShieldItem && event.getAmount() >= 3.0f && Utils.canBlockDamageSource((LivingEntity)player, event.getSource())) {
            float amount = event.getAmount();
            ((IEShieldItem)activeStack.m_41720_()).hitShield(activeStack, player, event.getSource(), amount, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float mod;
        int amp;
        if (event.getSource().m_19384_() && event.getEntity().m_21124_((MobEffect)IEPotions.FLAMMABLE.get()) != null) {
            amp = event.getEntity().m_21124_((MobEffect)IEPotions.FLAMMABLE.get()).m_19564_();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (("flux".equals(event.getSource().m_19385_()) || IEDamageSources.razorShock.equals(event.getSource()) || event.getSource() instanceof IEDamageSources.ElectricDamageSource) && event.getEntity().m_21124_((MobEffect)IEPotions.CONDUCTIVE.get()) != null) {
            amp = event.getEntity().m_21124_((MobEffect)IEPotions.CONDUCTIVE.get()).m_19564_();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (!event.isCanceled() && !event.getEntity().m_6072_() && event.getAmount() >= event.getEntity().m_21223_() && event.getSource().m_7639_() instanceof Player && ((Player)event.getSource().m_7639_()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof DrillItem) {
            Utils.unlockIEAdvancement((Player)event.getSource().m_7639_(), "tools/secret_drillbreak");
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3 motion = event.getEntity().m_20184_();
        if (event.getEntity().m_21124_((MobEffect)IEPotions.STICKY.get()) != null) {
            motion = motion.m_82492_(0.0, (double)((float)(event.getEntity().m_21124_((MobEffect)IEPotions.STICKY.get()).m_19564_() + 1) * 0.2f), 0.0);
        } else if (event.getEntity().m_21124_((MobEffect)IEPotions.CONCRETE_FEET.get()) != null) {
            motion = Vec3.f_82478_;
        }
        event.getEntity().m_20256_(motion);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        ItemStack powerpack;
        if (event.getEntity() instanceof Player && !event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41619_() && ItemNBTHelper.hasKey(event.getEntity().m_6844_(EquipmentSlot.CHEST), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getEntity().m_6844_(EquipmentSlot.CHEST), "IE:Powerpack")).m_41619_()) {
            powerpack.m_41720_().onArmorTick(powerpack, event.getEntity().m_20193_(), (Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        BlockEntity te;
        ItemStack current = event.getEntity().m_21120_(InteractionHand.MAIN_HAND);
        if (!current.m_41619_() && current.m_41720_() == IEItems.Tools.DRILL.get() && event.getEntity().m_204029_(FluidTags.f_13131_)) {
            if (IEItems.Tools.DRILL.get().getUpgrades(current).m_128471_("waterproof")) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().m_204336_(IETags.wirecutterHarvestable) && !current.canPerformAction(Lib.WIRECUTTER_DIG)) {
            event.setCanceled(true);
            if (event.getEntity().m_217043_().m_188503_(4) == 0) {
                RazorWireBlockEntity.applyDamage((LivingEntity)event.getEntity());
            }
        }
        if (event.getPosition().isPresent() && (te = event.getEntity().m_20193_().m_7702_((BlockPos)event.getPosition().get())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().m_41619_() && event.getLeft().m_41720_() instanceof IDrillHead && ((IDrillHead)event.getLeft().m_41720_()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().m_41619_() && event.getLeft().m_41720_().m_6832_(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().m_41777_());
            int repair = Math.min(((IDrillHead)event.getOutput().m_41720_()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().m_41720_()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().m_41613_(); ++cost) {
                ((IDrillHead)event.getOutput().m_41720_()).damageHead(event.getOutput(), -repair);
                event.setCost(Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().m_41720_()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().m_41720_()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().m_41788_()) {
                    event.setCost(event.getCost() + 5);
                    event.getOutput().m_41787_();
                }
            } else if (!event.getName().equals(event.getLeft().m_41786_().getString())) {
                event.setCost(event.getCost() + 5);
                if (event.getLeft().m_41788_()) {
                    event.setCost(event.getCost() + 2);
                }
                event.getOutput().m_41714_((Component)Component.m_237113_((String)event.getName()));
            }
        }
    }

    @SubscribeEvent
    public void onBlockRightclick(PlayerInteractEvent.RightClickBlock event) {
        LecternBlockEntity lectern;
        if (event.getLevel().f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        if (!(state.m_60734_() instanceof LecternBlock) || event.getEntity() == null) {
            return;
        }
        BlockEntity tile = event.getLevel().m_7702_(pos);
        if (tile instanceof LecternBlockEntity && (lectern = (LecternBlockEntity)tile).m_59566_().m_41720_() instanceof ManualItem) {
            if (!event.getEntity().m_6144_()) {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageOpenManual());
                }
            } else {
                Direction direction = (Direction)state.m_61143_((Property)LecternBlock.f_54465_);
                ItemStack itemstack = ((LecternBlockEntity)tile).m_59566_().m_41777_();
                float f = 0.25f * (float)direction.m_122429_();
                float f1 = 0.25f * (float)direction.m_122431_();
                ItemEntity itementity = new ItemEntity(event.getLevel(), (double)pos.m_123341_() + 0.5 + (double)f, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + (double)f1, itemstack);
                itementity.m_32060_();
                event.getLevel().m_7967_((Entity)itementity);
                lectern.m_6211_();
                LecternBlock.m_54497_((Level)event.getLevel(), (BlockPos)pos, (BlockState)state, (boolean)false);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void breakLast(BlockEvent.BreakEvent event) {
        BlockEntity te;
        if (event.getState().m_60734_() instanceof IEMultiblockBlock && (te = event.getLevel().m_7702_(event.getPos())) instanceof MultiblockPartBlockEntity) {
            MultiblockPartBlockEntity multiblockBE = (MultiblockPartBlockEntity)te;
            multiblockBE.onlyLocalDissassembly = event.getLevel().m_6106_().m_6793_();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!(event.getSource() instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        serverPlayer.m_36220_((ResourceLocation)IEStats.WIRE_DEATHS.get());
        if (serverPlayer.m_150110_().f_35935_ || serverPlayer.m_21255_()) {
            Utils.unlockIEAdvancement((Player)serverPlayer, "main/secret_friedbird");
        }
    }
}

