/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class PipeCallbacks
implements BlockCallback<Key> {
    public static final PipeCallbacks INSTANCE = new PipeCallbacks();
    private static final Key INVALID = new Key((Map)Util.m_137469_(new EnumMap(Direction.class), m -> {
        for (Direction d : DirectionUtils.VALUES) {
            m.put(d, FluidPipeBlockEntity.ConnectionStyle.NO_CONNECTION);
        }
    }), null, null);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof FluidPipeBlockEntity)) {
            return this.getDefaultKey();
        }
        FluidPipeBlockEntity pipeBE = (FluidPipeBlockEntity)blockEntity;
        EnumMap<Direction, FluidPipeBlockEntity.ConnectionStyle> connections = new EnumMap<Direction, FluidPipeBlockEntity.ConnectionStyle>(Direction.class);
        for (Direction face : DirectionUtils.VALUES) {
            connections.put(face, pipeBE.getConnectionStyle(face));
        }
        return new Key(connections, pipeBE.cover == Blocks.f_50016_ ? null : pipeBE.cover, pipeBE.getColor());
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public IEProperties.IEObjState getIEOBJState(Key key) {
        ArrayList<String> parts = new ArrayList<String>();
        Matrix4 rotationMatrix = new Matrix4();
        rotationMatrix.translate(0.5, 0.5, 0.5);
        if (key.cover() != null) {
            parts.add("cover");
        }
        int totalConnections = key.numActiveConnections();
        boolean straightY = key.all(Direction.UP, Direction.DOWN);
        boolean straightZ = key.all(Direction.NORTH, Direction.SOUTH);
        boolean straightX = key.all(Direction.EAST, Direction.WEST);
        switch (totalConnections) {
            case 0: {
                parts.add("center");
                break;
            }
            case 1: {
                parts.add("stopper");
                if (key.hasActiveConnection(Direction.UP)) {
                    rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                } else if (key.hasActiveConnection(Direction.NORTH)) {
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                } else if (key.hasActiveConnection(Direction.SOUTH)) {
                    rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                } else if (key.hasActiveConnection(Direction.WEST)) {
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                } else if (key.hasActiveConnection(Direction.EAST)) {
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                }
                parts.add("con_yMin");
                break;
            }
            case 2: {
                if (straightY) {
                    parts.add("pipe_y");
                    if (key.hasCouplingConnection(Direction.DOWN)) {
                        parts.add("con_yMin");
                    }
                    if (!key.hasCouplingConnection(Direction.UP)) break;
                    parts.add("con_yMax");
                    break;
                }
                if (straightZ) {
                    parts.add("pipe_z");
                    if (key.hasCouplingConnection(Direction.NORTH)) {
                        parts.add("con_zMin");
                    }
                    if (!key.hasCouplingConnection(Direction.SOUTH)) break;
                    parts.add("con_zMax");
                    break;
                }
                if (straightX) {
                    parts.add("pipe_x");
                    if (key.hasCouplingConnection(Direction.WEST)) {
                        parts.add("con_xMin");
                    }
                    if (!key.hasCouplingConnection(Direction.EAST)) break;
                    parts.add("con_xMax");
                    break;
                }
                parts.add("curve");
                parts.add("con_yMin");
                parts.add("con_zMin");
                if (key.any(Direction.UP, Direction.DOWN)) {
                    if (key.hasActiveConnection(Direction.WEST)) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    } else if (key.hasActiveConnection(Direction.EAST)) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                    } else if (key.hasActiveConnection(Direction.SOUTH)) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if (!key.hasActiveConnection(Direction.UP)) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    break;
                }
                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                if (key.all(Direction.SOUTH, Direction.EAST)) {
                    rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                    break;
                }
                if (key.all(Direction.SOUTH, Direction.WEST)) {
                    rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                if (!key.all(Direction.NORTH, Direction.EAST)) break;
                rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                break;
            }
            case 3: {
                if (straightX || straightZ || straightY) {
                    parts.add("tcross");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    if (straightX) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        if (key.hasActiveConnection(Direction.NORTH)) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (key.hasActiveConnection(Direction.SOUTH)) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!key.hasActiveConnection(Direction.UP)) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                        if (key.hasActiveConnection(Direction.WEST)) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (key.hasActiveConnection(Direction.EAST)) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!key.hasActiveConnection(Direction.SOUTH)) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (key.hasActiveConnection(Direction.WEST)) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (key.hasActiveConnection(Direction.EAST)) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!key.hasActiveConnection(Direction.UP)) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    break;
                }
                parts.add("tcurve");
                parts.add("con_yMin");
                parts.add("con_zMin");
                parts.add("con_xMax");
                if (key.hasActiveConnection(Direction.SOUTH)) {
                    if (key.hasActiveConnection(Direction.WEST)) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    } else {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                } else if (key.hasActiveConnection(Direction.WEST)) {
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                }
                if (!key.hasActiveConnection(Direction.UP)) break;
                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                break;
            }
            case 4: {
                boolean cross;
                boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                if (cross) {
                    parts.add("cross");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    if (!straightY) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    break;
                }
                parts.add("tcross2");
                parts.add("con_yMin");
                parts.add("con_zMin");
                parts.add("con_zMax");
                parts.add("con_xMax");
                if (straightZ) {
                    if (key.hasActiveConnection(Direction.WEST)) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if (!key.hasActiveConnection(Direction.UP)) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                if (straightY) {
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    if (key.hasActiveConnection(Direction.SOUTH)) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        if (!key.hasActiveConnection(Direction.WEST)) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!key.hasActiveConnection(Direction.WEST)) break;
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                if (key.hasActiveConnection(Direction.SOUTH)) {
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                }
                if (!key.hasActiveConnection(Direction.UP)) break;
                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                break;
            }
            case 5: {
                parts.add("tcross3");
                parts.add("con_yMin");
                parts.add("con_yMax");
                parts.add("con_zMin");
                parts.add("con_zMax");
                parts.add("con_xMax");
                if (straightZ) {
                    if (straightY) {
                        if (!key.hasActiveConnection(Direction.WEST)) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(key.hasActiveConnection(Direction.UP) ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                if (!straightX) break;
                rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                if (!key.hasActiveConnection(Direction.SOUTH)) break;
                rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                break;
            }
            case 6: {
                parts.add("con_yMin");
                parts.add("con_yMax");
                parts.add("con_zMin");
                parts.add("con_zMax");
                parts.add("con_xMin");
                parts.add("con_xMax");
            }
        }
        rotationMatrix.translate(-0.5, -0.5, -0.5);
        return new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts), new Transformation(rotationMatrix.toMatrix4f()));
    }

    @Override
    public List<BakedQuad> modifyQuads(Key key, List<BakedQuad> quads) {
        if (key.cover() != null) {
            BlockState state = key.cover().m_49966_();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
            for (RenderType layer : RenderType.m_110506_()) {
                for (Direction direction : Direction.values()) {
                    quads.addAll(model.getQuads(state, direction, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer));
                }
                quads.addAll(model.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer));
            }
        }
        return quads;
    }

    @Override
    public Vector4f getRenderColor(Key key, String group, String material, ShaderCase shaderCase, Vector4f original) {
        if (key.color() != null) {
            float[] rgb = key.color().m_41068_();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    public record Key(Map<Direction, FluidPipeBlockEntity.ConnectionStyle> connections, @Nullable Block cover, @Nullable DyeColor color) {
        int numActiveConnections() {
            int count = 0;
            for (FluidPipeBlockEntity.ConnectionStyle c : this.connections.values()) {
                if (c == FluidPipeBlockEntity.ConnectionStyle.NO_CONNECTION) continue;
                ++count;
            }
            return count;
        }

        public boolean hasActiveConnection(Direction side) {
            return this.connections.get(side) != FluidPipeBlockEntity.ConnectionStyle.NO_CONNECTION;
        }

        public boolean hasCouplingConnection(Direction side) {
            return this.connections.get(side) == FluidPipeBlockEntity.ConnectionStyle.FLANGE;
        }

        public boolean any(Direction ... sides) {
            for (Direction side : sides) {
                if (!this.hasActiveConnection(side)) continue;
                return true;
            }
            return false;
        }

        public boolean all(Direction ... sides) {
            for (Direction side : sides) {
                if (this.hasActiveConnection(side)) continue;
                return false;
            }
            return true;
        }
    }
}

