/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraftforge.client.model.IQuadTransformer;

public class QuadTransformer {
    public static IQuadTransformer color(Int2IntFunction colorTransform) {
        return quad -> {
            if (!quad.m_111304_()) {
                return;
            }
            int multiplier = (Integer)colorTransform.apply((Object)quad.m_111305_());
            if (multiplier == 0) {
                return;
            }
            int[] data = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                int colorId = i * IQuadTransformer.STRIDE + IQuadTransformer.COLOR;
                data[colorId] = QuadTransformer.modifyColor(data[colorId], 0, multiplier);
                data[colorId] = QuadTransformer.modifyColor(data[colorId], 8, multiplier);
                data[colorId] = QuadTransformer.modifyColor(data[colorId], 16, multiplier);
            }
        };
    }

    private static int modifyColor(int oldColor, int offsetBits, int packedMultiplier) {
        int mask = 255 << offsetBits;
        int oldSubColor = mask & oldColor;
        float subMultiplier = (float)(packedMultiplier >> offsetBits & 0xFF) / 255.0f;
        int newSubColor = (int)((float)oldSubColor * subMultiplier) & mask;
        return oldColor & ~mask | newSubColor;
    }
}

