/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TemplateMultiblock
implements MultiblockHandler.IMultiblock {
    private static final SetRestrictedField<Function<BlockState, ItemStack>> PICK_BLOCK = SetRestrictedField.common();
    private static final SetRestrictedField<BiFunction<ResourceLocation, MinecraftServer, StructureTemplate>> LOAD_TEMPLATE = SetRestrictedField.common();
    private static final SetRestrictedField<Function<StructureTemplate, List<StructureTemplate.Palette>>> GET_PALETTES = SetRestrictedField.common();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation loc;
    protected final BlockPos masterFromOrigin;
    protected final BlockPos triggerFromOrigin;
    protected final BlockPos size;
    protected final List<BlockMatcher.MatcherPredicate> additionalPredicates;
    @Nullable
    private StructureTemplate template;
    private BlockState trigger = Blocks.f_50016_.m_49966_();

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, List<BlockMatcher.MatcherPredicate> additionalPredicates) {
        this.loc = loc;
        this.masterFromOrigin = masterFromOrigin;
        this.triggerFromOrigin = triggerFromOrigin;
        this.size = size;
        this.additionalPredicates = additionalPredicates;
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size) {
        this(loc, masterFromOrigin, triggerFromOrigin, size, (Map<Block, TagKey<Block>>)ImmutableMap.of());
    }

    public TemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, Map<Block, TagKey<Block>> tags) {
        this(loc, masterFromOrigin, triggerFromOrigin, size, (List<BlockMatcher.MatcherPredicate>)ImmutableList.of((expected, found, world, pos) -> {
            TagKey tag = (TagKey)tags.get(expected.m_60734_());
            if (tag != null) {
                if (found.m_204336_(tag)) {
                    return BlockMatcher.Result.allow(2);
                }
                return BlockMatcher.Result.deny(2);
            }
            return BlockMatcher.Result.DEFAULT;
        }));
    }

    @Nonnull
    protected StructureTemplate getTemplate(@Nullable Level world) {
        return this.getTemplate(world == null ? null : world.m_7654_());
    }

    public ResourceLocation getTemplateLocation() {
        return this.loc;
    }

    @Nonnull
    public StructureTemplate getTemplate(@Nullable MinecraftServer server) {
        if (this.template == null) {
            this.template = LOAD_TEMPLATE.getValue().apply(this.loc, server);
            List<StructureTemplate.StructureBlockInfo> blocks = TemplateMultiblock.getStructureFromTemplate(this.template);
            for (int i = 0; i < blocks.size(); ++i) {
                StructureTemplate.StructureBlockInfo info = blocks.get(i);
                if (info.f_74675_.equals((Object)this.triggerFromOrigin)) {
                    this.trigger = info.f_74676_;
                }
                if (info.f_74676_ == Blocks.f_50016_.m_49966_()) {
                    blocks.remove(i);
                    --i;
                    continue;
                }
                if (!info.f_74676_.m_60795_()) continue;
                LOGGER.error("Found non-default air block in template {}", (Object)this.loc);
            }
        }
        return Objects.requireNonNull(this.template);
    }

    public void reset() {
        this.template = null;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return this.loc;
    }

    @Override
    public boolean isBlockTrigger(BlockState state, Direction d, @Nullable Level world) {
        this.getTemplate(world);
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, d.m_122424_());
        if (rot == null) {
            return false;
        }
        for (Mirror mirror : this.getPossibleMirrorStates()) {
            BlockState modifiedTrigger = this.applyToState(this.trigger, mirror, rot);
            if (!BlockMatcher.matches(modifiedTrigger, state, null, null, this.additionalPredicates).isAllow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean createStructure(Level world, BlockPos pos, Direction side, Player player) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, side.m_122424_());
        if (rot == null) {
            return false;
        }
        List<StructureTemplate.StructureBlockInfo> structure = this.getStructure(world);
        block0: for (Mirror mirror : this.getPossibleMirrorStates()) {
            StructurePlaceSettings placeSet = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rot);
            BlockPos origin = pos.m_121996_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)this.triggerFromOrigin));
            for (StructureTemplate.StructureBlockInfo info : structure) {
                BlockState inWorld;
                BlockPos realRelPos = StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)info.f_74675_);
                BlockPos here = origin.m_121955_((Vec3i)realRelPos);
                BlockState expected = this.applyToState(info.f_74676_, mirror, rot);
                if (BlockMatcher.matches(expected, inWorld = world.m_8055_(here), world, here, this.additionalPredicates).isAllow()) continue;
                continue block0;
            }
            this.form(world, origin, rot, mirror, side);
            return true;
        }
        return false;
    }

    private BlockState applyToState(BlockState in, Mirror m, Rotation r) {
        return in.m_60715_(m).m_60717_(r);
    }

    private List<Mirror> getPossibleMirrorStates() {
        if (this.canBeMirrored()) {
            return ImmutableList.of((Object)Mirror.NONE, (Object)Mirror.FRONT_BACK);
        }
        return ImmutableList.of((Object)Mirror.NONE);
    }

    protected void form(Level world, BlockPos pos, Rotation rot, Mirror mirror, Direction sideHit) {
        BlockPos masterPos = TemplateMultiblock.withSettingsAndOffset(pos, this.masterFromOrigin, mirror, rot);
        for (StructureTemplate.StructureBlockInfo block : this.getStructure(world)) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(pos, block.f_74675_, mirror, rot);
            this.replaceStructureBlock(block, world, actualPos, mirror != Mirror.NONE, sideHit, (Vec3i)actualPos.m_121996_((Vec3i)masterPos));
        }
    }

    public BlockPos getMasterFromOriginOffset() {
        return this.masterFromOrigin;
    }

    protected abstract void replaceStructureBlock(StructureTemplate.StructureBlockInfo var1, Level var2, BlockPos var3, boolean var4, Direction var5, Vec3i var6);

    @Override
    public List<StructureTemplate.StructureBlockInfo> getStructure(@Nullable Level world) {
        return TemplateMultiblock.getStructureFromTemplate(this.getTemplate(world));
    }

    private static List<StructureTemplate.StructureBlockInfo> getStructureFromTemplate(StructureTemplate template) {
        return GET_PALETTES.getValue().apply(template).get(0).m_74652_();
    }

    @Override
    public Vec3i getSize(@Nullable Level world) {
        return this.getTemplate(world).m_163801_();
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, Mirror mirror, Rotation rot) {
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rot);
        return origin.m_121955_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)relative));
    }

    public static BlockPos withSettingsAndOffset(BlockPos origin, BlockPos relative, boolean mirrored, Direction facing) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, facing);
        if (rot == null) {
            return origin;
        }
        return TemplateMultiblock.withSettingsAndOffset(origin, relative, mirrored ? Mirror.FRONT_BACK : Mirror.NONE, rot);
    }

    @Override
    public void disassemble(Level world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, clickDirectionAtCreation);
        Preconditions.checkNotNull((Object)rot);
        for (StructureTemplate.StructureBlockInfo block : this.getStructure(world)) {
            BlockPos actualPos = TemplateMultiblock.withSettingsAndOffset(origin, block.f_74675_, mirror, rot);
            this.prepareBlockForDisassembly(world, actualPos);
            world.m_46597_(actualPos, block.f_74676_.m_60715_(mirror).m_60717_(rot));
        }
    }

    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
    }

    @Override
    public BlockPos getTriggerOffset() {
        return this.triggerFromOrigin;
    }

    public boolean canBeMirrored() {
        return true;
    }

    public static void setCallbacks(Function<BlockState, ItemStack> pickBlock, BiFunction<ResourceLocation, MinecraftServer, StructureTemplate> loadTemplate, Function<StructureTemplate, List<StructureTemplate.Palette>> getPalettes) {
        PICK_BLOCK.setValue(pickBlock);
        LOAD_TEMPLATE.setValue(loadTemplate);
        GET_PALETTES.setValue(getPalettes);
    }
}

