/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.network.MessageSerializer;
import vazkii.quark.api.IRotationLockable;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SetLockProfileMessage;
import vazkii.quark.content.building.block.VerticalSlabBlock;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class LockRotationModule
extends QuarkModule {
    private static final String TAG_LOCKED_ONCE = "quark:locked_once";
    private static final HashMap<UUID, LockProfile> lockProfiles = new HashMap();
    @OnlyIn(value=Dist.CLIENT)
    private LockProfile clientProfile;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keybind;

    @Override
    public void configChanged() {
        lockProfiles.clear();
    }

    @Override
    public void setup() {
        MessageSerializer.mapHandlers(LockProfile.class, LockProfile::readProfile, LockProfile::writeProfile);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        this.keybind = ModKeybindHandler.init(event, "lock_rotation", "k", "quark.gui.keygroup.misc");
    }

    public static BlockState fixBlockRotation(BlockState state, BlockPlaceContext ctx) {
        if (state == null || ctx.m_43723_() == null || !ModuleLoader.INSTANCE.isModuleEnabled(LockRotationModule.class)) {
            return state;
        }
        UUID uuid = ctx.m_43723_().m_20148_();
        if (lockProfiles.containsKey(uuid)) {
            LockProfile profile = lockProfiles.get(uuid);
            BlockState transformed = LockRotationModule.getRotatedState(ctx.m_43725_(), ctx.m_8083_(), state, profile.facing.m_122424_(), profile.half);
            if (!transformed.equals(state)) {
                return Block.m_49931_((BlockState)transformed, (LevelAccessor)ctx.m_43725_(), (BlockPos)ctx.m_8083_());
            }
        }
        return state;
    }

    public static BlockState getRotatedState(Level world, BlockPos pos, BlockState state, Direction face, int half) {
        BlockState setState = state;
        ImmutableMap props = state.m_61148_();
        Block block = state.m_60734_();
        if (block instanceof IRotationLockable) {
            IRotationLockable lockable = (IRotationLockable)block;
            setState = lockable.applyRotationLock(world, pos, state, face, half);
        } else if (props.containsKey((Object)BlockStateProperties.f_61372_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
        } else if (props.containsKey(VerticalSlabBlock.TYPE) && props.get(VerticalSlabBlock.TYPE) != VerticalSlabBlock.VerticalSlabType.DOUBLE && face.m_122434_() != Direction.Axis.Y) {
            setState = (BlockState)state.m_61124_(VerticalSlabBlock.TYPE, (Comparable)((Object)Objects.requireNonNull(VerticalSlabBlock.VerticalSlabType.fromDirection(face))));
        } else if (props.containsKey((Object)BlockStateProperties.f_61374_) && face.m_122434_() != Direction.Axis.Y) {
            setState = block instanceof StairBlock ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face.m_122424_()) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
        } else if (props.containsKey((Object)BlockStateProperties.f_61365_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)face.m_122434_());
        } else if (props.containsKey((Object)BlockStateProperties.f_61373_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)(face == Direction.DOWN ? face : face.m_122424_()));
        }
        if (half != -1) {
            if (props.containsKey((Object)BlockStateProperties.f_61397_) && props.get((Object)BlockStateProperties.f_61397_) != SlabType.DOUBLE) {
                setState = (BlockState)setState.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(half == 1 ? SlabType.TOP : SlabType.BOTTOM));
            } else if (props.containsKey((Object)BlockStateProperties.f_61402_)) {
                setState = (BlockState)setState.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(half == 1 ? Half.TOP : Half.BOTTOM));
            }
        }
        return setState;
    }

    @SubscribeEvent
    public void onPlayerLogoff(PlayerEvent.PlayerLoggedOutEvent event) {
        lockProfiles.remove(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseButton event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.Key event) {
        this.acceptInput();
    }

    /*
     * Unable to fully structure code
     */
    private void acceptInput() {
        block5: {
            mc = Minecraft.m_91087_();
            down = this.keybind.m_90857_();
            if (!mc.m_91302_() || !down || mc.f_91080_ != null) break block5;
            result = mc.f_91077_;
            if (!(result instanceof BlockHitResult)) ** GOTO lbl-1000
            bresult = (BlockHitResult)result;
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                hitVec = bresult.m_82450_();
                face = bresult.m_82434_();
                half = Math.abs((int)((hitVec.f_82480_ - (double)((int)hitVec.f_82480_)) * 2.0));
                if (face.m_122434_() == Direction.Axis.Y) {
                    half = -1;
                } else if (hitVec.f_82480_ < 0.0) {
                    half = 1 - half;
                }
                newProfile = new LockProfile(face.m_122424_(), half);
            } else lbl-1000:
            // 2 sources

            {
                look = mc.f_91074_.m_20154_();
                newProfile = new LockProfile(Direction.m_122372_((float)((float)look.f_82479_), (float)((float)look.f_82480_), (float)((float)look.f_82481_)), -1);
            }
            this.clientProfile = this.clientProfile != null && this.clientProfile.equals(newProfile) != false ? null : newProfile;
            QuarkNetwork.sendToServer(new SetLockProfileMessage(this.clientProfile));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHUDRender(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && this.clientProfile != null) {
            PoseStack matrix = event.getPoseStack();
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
            Window window = event.getWindow();
            int x = window.m_85445_() / 2 + 20;
            int y = window.m_85446_() / 2 - 8;
            Screen.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)(this.clientProfile.facing.ordinal() * 16), (float)65.0f, (int)16, (int)16, (int)256, (int)256);
            if (this.clientProfile.half > -1) {
                Screen.m_93133_((PoseStack)matrix, (int)(x + 16), (int)y, (float)(this.clientProfile.half * 16), (float)79.0f, (int)16, (int)16, (int)256, (int)256);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void setProfile(Player player, LockProfile profile) {
        UUID uuid = player.m_20148_();
        if (profile == null) {
            lockProfiles.remove(uuid);
        } else {
            boolean locked = player.getPersistentData().m_128471_(TAG_LOCKED_ONCE);
            if (!locked) {
                MutableComponent keybind = Component.m_237117_((String)"quark.keybind.lock_rotation").m_130940_(ChatFormatting.AQUA);
                MutableComponent text = Component.m_237110_((String)"quark.misc.rotation_lock", (Object[])new Object[]{keybind});
                player.m_213846_((Component)text);
                player.getPersistentData().m_128379_(TAG_LOCKED_ONCE, true);
            }
            lockProfiles.put(uuid, profile);
        }
    }

    public record LockProfile(Direction facing, int half) {
        public static LockProfile readProfile(FriendlyByteBuf buf, Field field) {
            boolean valid = buf.readBoolean();
            if (!valid) {
                return null;
            }
            int face = buf.readInt();
            int half = buf.readInt();
            return new LockProfile(Direction.m_122376_((int)face), half);
        }

        public static void writeProfile(FriendlyByteBuf buf, Field field, LockProfile p) {
            if (p == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(p.facing.m_122411_());
                buf.writeInt(p.half);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof LockProfile)) {
                return false;
            }
            LockProfile otherProfile = (LockProfile)other;
            return otherProfile.facing == this.facing && otherProfile.half == this.half;
        }

        @Override
        public int hashCode() {
            return this.facing.hashCode() * 31 + this.half;
        }
    }
}

