/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.desiredservers;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.kreezcraft.desiredservers.Constants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;

public class CommonClass {
    private static FileReader serversFile;

    public static void onInitializeClient() {
        File featuredServerList;
        File configFolder = new File(Minecraft.m_91087_().f_91069_, "config/desiredservers");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(featuredServerList = new File(configFolder, "desiredservers.json")).exists()) {
            try {
                featuredServerList.createNewFile();
                FileWriter writer = new FileWriter(featuredServerList);
                writer.write("[\n  {\n    \"serverName\": \"Featured Server\",\n    \"serverIP\": \"127.0.0.1\",\n    \"forceResourcePack\": \"true\"\n  },\n  {\n    \"serverName\": \"Another Server!\",\n    \"serverIP\": \"192.168.1.1\",\n    \"forceResourcePack\": \"false\"\n  }\n]");
                writer.close();
            }
            catch (Throwable t) {
                Constants.LOG.error("Could create the default config file for Featured Servers Deus Ex\nException was: " + t.getMessage());
                return;
            }
        }
        try {
            serversFile = new FileReader(featuredServerList.getPath());
        }
        catch (Throwable t) {
            Constants.LOG.error("Could create the default config file for Featured Servers Deus Ex\nException was: " + t.getMessage());
            return;
        }
        Gson gson = new Gson();
        JsonReader reader = new JsonReader((Reader)serversFile);
        ServerDataHelper[] featuredList = (ServerDataHelper[])gson.fromJson(reader, ServerDataHelper[].class);
        if (featuredList == null) {
            return;
        }
        ServerList serverList = new ServerList(Minecraft.m_91087_());
        for (ServerDataHelper serverhelp : featuredList) {
            ServerData server = new ServerData(serverhelp.serverName, serverhelp.serverIP, false);
            if (serverhelp.forceResourcePack != null && serverhelp.forceResourcePack.booleanValue()) {
                server.m_105379_(ServerData.ServerPackStatus.ENABLED);
            }
            if (CommonClass.inList(server, serverList)) {
                Constants.LOG.info("Featured server already in server list");
                continue;
            }
            Constants.LOG.info("Adding featured server");
            serverList.m_233842_(server, false);
            serverList.m_105442_();
        }
    }

    public static boolean inList(ServerData server, ServerList list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.m_105445_(); ++i) {
            ServerData data = list.m_105432_(i);
            if (!data.f_105363_.equalsIgnoreCase(server.f_105363_) || !data.f_105362_.equalsIgnoreCase(server.f_105362_)) continue;
            return true;
        }
        return false;
    }

    public static class ServerDataHelper {
        public String serverName;
        public String serverIP;
        public Boolean forceResourcePack;
    }
}

