/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import com.bluepowermod.tile.TileBPMultipart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartUtils {
    public static Pair<Vec3, Vec3> getRayTraceVectors(Entity entity) {
        float pitch = entity.f_19860_;
        float yaw = entity.f_19859_;
        Vec3 start = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        float f1 = (float)Math.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = (float)Math.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = -((float)Math.cos(-pitch * ((float)Math.PI / 180)));
        float f4 = (float)Math.sin(-pitch * ((float)Math.PI / 180));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof ServerPlayer) {
            d3 = ((ServerPlayer)entity).m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        }
        Vec3 end = start.m_82520_((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    @Nullable
    public static BlockState getClosestState(Entity entity, BlockPos pos) {
        Pair<Vec3, Vec3> lookVec = MultipartUtils.getRayTraceVectors(entity);
        return MultipartUtils.getClosestState(entity.f_19853_, (Vec3)lookVec.getLeft(), (Vec3)lookVec.getRight(), pos);
    }

    @Nullable
    public static BlockState getClosestState(Level world, Vec3 start, Vec3 end, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        BlockState state = null;
        double distance = Double.POSITIVE_INFINITY;
        if (te instanceof TileBPMultipart) {
            for (BlockState part : ((TileBPMultipart)te).getStates()) {
                double partDistance;
                BlockHitResult res = part.m_60771_((BlockGetter)world, pos, CollisionContext.m_82749_()).m_83220_(start, end, pos);
                if (res == null || !(distance > (partDistance = start.m_82557_(res.m_82450_())))) continue;
                distance = partDistance;
                state = part;
            }
        }
        return state;
    }
}

