/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSolarPanel
extends TileMachineBase {
    private final int MAX_VOLTAGE = 100;
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileSolarPanel(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.SOLAR_PANEL.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public static void tickSolarPanel(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (!level.f_46443_ && blockEntity instanceof TileSolarPanel) {
            TileSolarPanel tileSolarPanel = (TileSolarPanel)blockEntity;
            tileSolarPanel.storage.resetCurrent();
            if (level.m_46461_() && level.m_45527_(pos) && tileSolarPanel.storage.getEnergy() < (double)tileSolarPanel.MAX_VOLTAGE && !level.m_46471_()) {
                tileSolarPanel.storage.addEnergy(0.2, false);
            }
            for (Direction facing : Direction.values()) {
                BlockEntity tile = level.m_7702_(pos.m_121945_(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, tileSolarPanel.storage));
            }
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundTag tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.m_128441_("energy")) {
            Tag nbtstorage = tCompound.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag tCompound) {
        super.writeToPacketNBT(tCompound);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        tCompound.m_128365_("energy", nbtstorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

