/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.IFuzzyRetrieving;
import com.bluepowermod.tile.IRejectAnimator;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.TileMachineBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileManager
extends TileMachineBase
implements WorldlyContainer,
IRejectAnimator,
IFuzzyRetrieving,
IGuiButtonSensitive {
    public static final int SLOTS = 25;
    protected final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)25, (Object)ItemStack.f_41583_);
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int priority;
    public int mode;
    public int fuzzySetting;
    private int rejectTicker = -1;

    public TileManager(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.MANAGER.get(), pos, state);
    }

    private int acceptedItems(ItemStack item) {
        if (item.m_41619_()) {
            return 0;
        }
        int managerCount = IOHelper.getItemCount(item, this, null, this.fuzzySetting);
        if (this.mode == 1 && managerCount > 0) {
            return item.m_41613_();
        }
        return managerCount - IOHelper.getItemCount(item, this.getTileCache(this.getFacingDirection()), this.getFacingDirection().m_122424_(), this.fuzzySetting);
    }

    @Override
    public void onButtonPress(Player player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 2) {
            this.priority = value;
        } else {
            this.fuzzySetting = value;
        }
    }

    public static void tickManager(Level level, BlockPos pos, BlockState state, TileManager blockEntity) {
        if (!level.f_46443_ && blockEntity.getTicker() % 10 == 0) {
            blockEntity.dumpUnwantedItems();
            blockEntity.retrieveItemsFromManagers();
            blockEntity.setOutputtingRedstone(blockEntity.mode == 0 && blockEntity.shouldEmitRedstone());
        }
        if (blockEntity.rejectTicker >= 0 && ++blockEntity.rejectTicker > 7) {
            blockEntity.rejectTicker = -1;
            blockEntity.markForRenderUpdate();
        }
        TileBase.tickTileBase(level, pos, state, blockEntity);
    }

    private boolean shouldEmitRedstone() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_() || this.acceptedItems(stack) <= 0) continue;
            return false;
        }
        return true;
    }

    private void retrieveItemsFromManagers() {
    }

    private void dumpUnwantedItems() {
        int[] slots;
        BlockEntity te = this.getTileCache(this.getFacingDirection());
        Container inv = IOHelper.getInventoryForTE(te);
        for (int slot : slots = IOHelper.getAccessibleSlotsForInventory(inv, this.getFacingDirection().m_122424_())) {
            ItemStack stack = inv.m_8020_(slot);
            int acceptedItems = this.acceptedItems(stack);
            if (acceptedItems >= 0) continue;
            int rejectedItems = -acceptedItems;
            ItemStack rejectingStack = stack.m_41777_();
            rejectingStack.m_41764_(Math.min(rejectedItems, rejectingStack.m_41741_()));
            rejectingStack = IOHelper.extract(te, this.getFacingDirection().m_122424_(), rejectingStack, true, false, this.fuzzySetting);
            if (rejectingStack.m_41619_()) continue;
            this.addItemToOutputBuffer(rejectingStack, this.filterColor);
        }
    }

    @Override
    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        for (int i = 0; i < 24; ++i) {
            CompoundTag tc = tCompound.m_128469_("inventory" + i);
            this.inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)tc));
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.m_128445_("filterColor")];
        this.mode = tCompound.m_128445_("mode");
        this.priority = tCompound.m_128445_("priority");
        this.fuzzySetting = tCompound.m_128445_("fuzzySetting");
    }

    @Override
    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        for (int i = 0; i < 24; ++i) {
            CompoundTag tc = new CompoundTag();
            ((ItemStack)this.inventory.get(i)).m_41739_(tc);
            tCompound.m_128365_("inventory" + i, (Tag)tc);
        }
        tCompound.m_128344_("filterColor", (byte)this.filterColor.ordinal());
        tCompound.m_128344_("mode", (byte)this.mode);
        tCompound.m_128344_("priority", (byte)this.priority);
        tCompound.m_128344_("fuzzySetting", (byte)this.fuzzySetting);
    }

    @Override
    public void writeToPacketNBT(CompoundTag tag) {
        super.writeToPacketNBT(tag);
        tag.m_128344_("rejectAnimation", (byte)this.rejectTicker);
    }

    @Override
    public void readFromPacketNBT(CompoundTag tag) {
        super.readFromPacketNBT(tag);
        this.rejectTicker = tag.m_128445_("rejectAnimation");
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        return this.inventory.size() == 0;
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = this.m_8020_(i);
        if (itemStack != ItemStack.f_41583_) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58858_.m_123314_(new Vec3i(player.m_20185_(), player.m_20186_(), player.m_20189_()), 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return true;
    }

    public void m_6211_() {
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] m_7071_(Direction side) {
        Direction direction = this.getFacingDirection();
        if (side == direction || side == direction.m_122424_()) {
            return new int[0];
        }
        int[] slots = new int[this.inventory.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public boolean isRejecting() {
        return this.rejectTicker >= 0;
    }

    @Override
    public int getFuzzySetting() {
        return this.fuzzySetting;
    }
}

