/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.api.tube.IWeightedTubeInventory;
import com.bluepowermod.container.stack.TubeStack;
import com.bluepowermod.helper.BlockEntityCache;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidBlock;

public class TileMachineBase
extends TileBase
implements ITubeConnection,
IWeightedTubeInventory,
IEjectAnimator {
    protected boolean spawnItemsInWorld = true;
    protected boolean acceptsTubeItems = true;
    private final List<TubeStack> internalItemStackBuffer = new ArrayList<TubeStack>();
    private BlockEntityCache tileCache;
    public static final int BUFFER_EMPTY_INTERVAL = 10;
    protected byte animationTicker = (byte)-1;
    protected static final int ANIMATION_TIME = 7;
    private boolean isAnimating;
    protected boolean ejectionScheduled;
    private static final int WARNING_INTERVAL = 600;

    public TileMachineBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tickMachineBase(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        TileMachineBase.tickTileBase(level, pos, state, blockEntity);
        if (!level.f_46443_ && blockEntity instanceof TileMachineBase) {
            TileMachineBase machineBase = (TileMachineBase)blockEntity;
            if (machineBase.ejectionScheduled || machineBase.getTicker() % 10 == 0) {
                machineBase.ejectItems();
                machineBase.ejectionScheduled = false;
            }
        }
    }

    private void ejectItems() {
        Iterator<TubeStack> iterator = this.internalItemStackBuffer.iterator();
        while (iterator.hasNext()) {
            TubeStack tubeStack = iterator.next();
            if (IOHelper.canInterfaceWith(this.getTileCache(this.getOutputDirection()), this.getFacingDirection())) {
                ItemStack returnedStack = IOHelper.insert(this.getTileCache(this.getOutputDirection()), tubeStack.stack, this.getFacingDirection(), tubeStack.color, false);
                if (returnedStack.m_41619_()) {
                    iterator.remove();
                    this.m_6596_();
                    if (this.ejectionScheduled) continue;
                    break;
                }
                if (returnedStack.m_41613_() == tubeStack.stack.m_41613_()) break;
                this.m_6596_();
                if (this.ejectionScheduled) continue;
                break;
            }
            if (!this.spawnItemsInWorld) continue;
            Direction direction = this.getFacingDirection().m_122424_();
            Block block = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction)).m_60734_();
            if (this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction)).m_60815_() && !(block instanceof IFluidBlock)) break;
            this.ejectItemInWorld(tubeStack.stack, direction);
            iterator.remove();
            this.m_6596_();
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.tileCache = null;
    }

    public void m_6596_() {
        super.m_6596_();
        this.tileCache = null;
    }

    protected void addItemToOutputBuffer(ItemStack stack, IPneumaticTube.TubeColor color) {
        if (!this.f_58857_.f_46443_) {
            this.internalItemStackBuffer.add(new TubeStack(stack, this.getOutputDirection().m_122424_(), color));
            if (this.internalItemStackBuffer.size() == 1) {
                this.ejectionScheduled = true;
            }
            this.animationTicker = 0;
            this.sendUpdatePacket();
            this.m_6596_();
        }
    }

    public List<TubeStack> getBacklog() {
        return this.internalItemStackBuffer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setBacklog(List<TubeStack> backlog) {
        this.internalItemStackBuffer.clear();
        this.internalItemStackBuffer.addAll(backlog);
    }

    protected void addItemToOutputBuffer(ItemStack stack) {
        this.addItemToOutputBuffer(stack, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks) {
        this.addItemsToOutputBuffer(stacks, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks, IPneumaticTube.TubeColor color) {
        for (ItemStack stack : stacks) {
            this.addItemToOutputBuffer(stack, color);
        }
    }

    protected boolean isBufferEmpty() {
        return this.internalItemStackBuffer.isEmpty();
    }

    public BlockEntity getTileCache(Direction d) {
        if (this.tileCache == null) {
            this.tileCache = new BlockEntityCache(this.f_58857_, this.f_58858_);
        }
        return (BlockEntity)this.tileCache.getValue(d);
    }

    public Direction getOutputDirection() {
        return this.getFacingDirection().m_122424_();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        ListTag nbttaglist = compound.m_128437_("ItemBuffer", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
            this.internalItemStackBuffer.add(TubeStack.loadFromNBT(nbttagcompound1));
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag nbttaglist = new ListTag();
        for (TubeStack tubeStack : this.internalItemStackBuffer) {
            if (tubeStack == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            tubeStack.writeToNBT(nbttagcompound1);
            nbttaglist.add((Object)nbttagcompound1);
        }
        compound.m_128365_("ItemBuffer", (Tag)nbttaglist);
    }

    public void ejectItemInWorld(ItemStack stack, Direction oppDirection) {
        float spawnX = (float)this.f_58858_.m_123341_() + 0.5f + (float)oppDirection.m_122429_() * 0.8f;
        float spawnY = (float)this.f_58858_.m_123342_() + 0.5f + (float)oppDirection.m_122430_() * 0.8f;
        float spawnZ = (float)this.f_58858_.m_123343_() + 0.5f + (float)oppDirection.m_122431_() * 0.8f;
        ItemEntity droppedItem = new ItemEntity(this.f_58857_, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
        droppedItem.m_20334_((double)((float)oppDirection.m_122429_() * 0.2f), (double)((float)oppDirection.m_122430_() * 0.2f), (double)((float)oppDirection.m_122431_() * 0.2f));
        this.f_58857_.m_7967_((Entity)droppedItem);
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (TubeStack stack : this.internalItemStackBuffer) {
            drops.add((Object)stack.stack);
        }
        return drops;
    }

    @Override
    public boolean isConnectedTo(Direction from) {
        Direction dir = this.getOutputDirection();
        return from == dir.m_122424_() || this.acceptsTubeItems && from == dir;
    }

    @Override
    public int getWeight(Direction from) {
        return from == this.getOutputDirection().m_122424_() ? 1000000 : 0;
    }

    @Override
    public boolean isEjecting() {
        return this.isAnimating;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addWailaInfo(List<String> info) {
        if (this.isEjecting()) {
            info.add(MinecraftColor.RED.getChatColor() + "[" + I18n.m_118938_((String)"waila.machine.stuffed", (Object[])new Object[0]) + "]");
        }
    }
}

