/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.tile.IRotatable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileBase
extends BlockEntity
implements IRotatable {
    private boolean isRedstonePowered;
    private int outputtingRedstone;
    private int ticker = 0;

    public TileBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        this.isRedstonePowered = tCompound.m_128471_("isRedstonePowered");
        this.readFromPacketNBT(tCompound);
    }

    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        tCompound.m_128379_("isRedstonePowered", this.isRedstonePowered);
        this.writeToPacketNBT(tCompound);
    }

    protected void writeToPacketNBT(CompoundTag tCompound) {
        tCompound.m_128344_("outputtingRedstone", (byte)this.outputtingRedstone);
    }

    protected void readFromPacketNBT(CompoundTag tCompound) {
        this.outputtingRedstone = tCompound.m_128445_("outputtingRedstone");
        if (this.f_58857_ != null) {
            this.markForRenderUpdate();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.readFromPacketNBT(pkt.m_131708_());
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    protected void sendUpdatePacket() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    protected void markForRenderUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6550_(this.m_58899_(), this.m_58900_(), this.m_58900_());
        }
    }

    protected void notifyNeighborBlockUpdate() {
    }

    public static void setChanged(Level level, BlockPos pos, BlockState state, TileBase blockEntity) {
        TileBase.checkRedstonePower(level, pos, state, blockEntity);
    }

    public static void checkRedstonePower(Level level, BlockPos pos, BlockState state, TileBase blockEntity) {
        boolean isIndirectlyPowered;
        boolean bl = isIndirectlyPowered = level.m_46755_(pos) != 0;
        if (isIndirectlyPowered && !blockEntity.getIsRedstonePowered()) {
            blockEntity.redstoneChanged(true);
        } else if (blockEntity.getIsRedstonePowered() && !isIndirectlyPowered) {
            blockEntity.redstoneChanged(false);
        }
    }

    public void setOutputtingRedstone(boolean newValue) {
        this.setOutputtingRedstone(newValue ? 15 : 0);
    }

    public void setOutputtingRedstone(int value) {
        value = Math.max(0, value);
        if (this.outputtingRedstone != (value = Math.min(15, value))) {
            this.outputtingRedstone = value;
            this.notifyNeighborBlockUpdate();
        }
    }

    public int getOutputtingRedstone() {
        return this.outputtingRedstone;
    }

    protected void redstoneChanged(boolean newValue) {
        this.isRedstonePowered = newValue;
    }

    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    public int getTicker() {
        return this.ticker;
    }

    protected static void onTileLoaded(Level level, BlockPos pos, BlockState state, TileBase blockEntity) {
        if (level != null && !level.f_46443_) {
            TileBase.setChanged(level, pos, state, blockEntity);
        }
    }

    public NonNullList<ItemStack> getDrops() {
        return NonNullList.m_122779_();
    }

    @Override
    public void setFacingDirection(Direction dir) {
        if (this.m_58900_().m_60734_() instanceof BlockContainerFacingBase) {
            BlockContainerFacingBase.setState(dir, this.f_58857_, this.m_58899_());
            if (this.f_58858_ != null) {
                this.sendUpdatePacket();
                this.notifyNeighborBlockUpdate();
            }
        }
    }

    @Override
    public Direction getFacingDirection() {
        if (this.m_58900_().m_60734_() instanceof BlockContainerFacingBase) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockContainerFacingBase.FACING);
        }
        return Direction.UP;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public static void tickTileBase(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        TileBase tileBase = (TileBase)blockEntity;
        if (tileBase.ticker == 0) {
            TileBase.onTileLoaded(level, pos, state, tileBase);
        }
        ++tileBase.ticker;
    }
}

