/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.helper.ItemStackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class IOHelper {
    public static Container getInventoryForTE(BlockEntity te) {
        if (te instanceof Container) {
            Container inv = (Container)te;
            BlockState block = te.m_58900_();
            if (block.m_60734_() instanceof ChestBlock) {
                inv = (Container)((ChestBlock)block.m_60734_()).m_7246_(block, te.m_58904_(), te.m_58899_());
            }
            return inv;
        }
        return null;
    }

    public static ItemStack extract(BlockEntity inventory, Direction direction, boolean simulate) {
        Container inv = IOHelper.getInventoryForTE(inventory);
        if (inv != null) {
            return IOHelper.extract(inv, direction, simulate);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack extract(Container inventory, Direction direction, boolean simulate) {
        if (inventory instanceof WorldlyContainer) {
            int[] accessibleSlotsFromSide;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            for (int anAccessibleSlotsFromSide : accessibleSlotsFromSide = isidedinventory.m_7071_(direction)) {
                ItemStack stack = IOHelper.extract(inventory, direction, anAccessibleSlotsFromSide, simulate);
                if (stack.m_41619_()) continue;
                return stack;
            }
        } else {
            int j = inventory.m_6643_();
            for (int k = 0; k < j; ++k) {
                ItemStack stack = IOHelper.extract(inventory, direction, k, simulate);
                if (stack.m_41619_()) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack extract(Container inventory, Direction direction, int slot, boolean simulate) {
        ItemStack itemstack = inventory.m_8020_(slot);
        if (!itemstack.m_41619_() && IOHelper.canTakeItemThroughFaceFromInventory(inventory, itemstack, slot, direction.ordinal())) {
            if (!simulate) {
                inventory.m_6836_(slot, ItemStack.f_41583_);
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack extract(BlockEntity tile, Direction direction, ItemStack requestedStack, boolean useItemCount, boolean simulate) {
        return IOHelper.extract(tile, direction, requestedStack, useItemCount, simulate, 0);
    }

    public static int[] getAccessibleSlotsForInventory(Container inv, Direction side) {
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof WorldlyContainer) {
                accessibleSlots = ((WorldlyContainer)inv).m_7071_(side);
            } else {
                accessibleSlots = new int[inv.m_6643_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            return accessibleSlots;
        }
        return new int[0];
    }

    public static int getItemCount(ItemStack type, BlockEntity inv, Direction side, int fuzzySetting) {
        Container inventory = IOHelper.getInventoryForTE(inv);
        int[] slots = IOHelper.getAccessibleSlotsForInventory(inventory, side);
        int count = 0;
        for (int slot : slots) {
            ItemStack invStack = inventory.m_8020_(slot);
            if (invStack.m_41619_() || !ItemStackHelper.areStacksEqual(invStack, type, fuzzySetting)) continue;
            count += invStack.m_41613_();
        }
        return count;
    }

    public static ItemStack extract(BlockEntity tile, Direction direction, ItemStack requestedStack, boolean useItemCount, boolean simulate, int fuzzySetting) {
        if (requestedStack.m_41619_()) {
            return requestedStack;
        }
        Container inv = IOHelper.getInventoryForTE(tile);
        if (!inv.m_7983_()) {
            int[] accessibleSlots;
            if (inv instanceof WorldlyContainer) {
                accessibleSlots = ((WorldlyContainer)inv).m_7071_(direction);
            } else {
                accessibleSlots = new int[inv.m_6643_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            int itemsFound = 0;
            for (int slot : accessibleSlots) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_() || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canTakeItemThroughFaceFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                if (!useItemCount) {
                    if (!simulate) {
                        inv.m_6836_(slot, ItemStack.f_41583_);
                    }
                    return stack;
                }
                itemsFound += stack.m_41613_();
            }
            if (itemsFound >= requestedStack.m_41613_()) {
                ItemStack exportedStack = ItemStack.f_41583_;
                int itemsNeeded = requestedStack.m_41613_();
                for (int slot : accessibleSlots) {
                    ItemStack stack = inv.m_8020_(slot);
                    if (stack.m_41619_() || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canTakeItemThroughFaceFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                    int itemsSubstracted = Math.min(itemsNeeded, stack.m_41613_());
                    if (itemsSubstracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubstracted;
                    if (simulate) continue;
                    stack.m_41764_(stack.m_41613_() - itemsSubstracted);
                    if (stack.m_41613_() == 0) {
                        inv.m_6836_(slot, ItemStack.f_41583_);
                    }
                    tile.m_6596_();
                }
                exportedStack = exportedStack.m_41777_();
                exportedStack.m_41764_(requestedStack.m_41613_());
                return exportedStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack extractOneItem(BlockEntity tile, Direction dir) {
        Container inv = IOHelper.getInventoryForTE(tile);
        if (inv != null && !inv.m_7983_()) {
            int[] accessibleSlots;
            if (inv instanceof WorldlyContainer) {
                accessibleSlots = ((WorldlyContainer)inv).m_7071_(dir);
            } else {
                accessibleSlots = new int[inv.m_6643_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            for (int slot : accessibleSlots) {
                ItemStack retrievingStack;
                ItemStack stack = inv.m_8020_(slot);
                ItemStack itemStack = retrievingStack = stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_().m_41620_(1);
                if (stack.m_41619_() || !IOHelper.canTakeItemThroughFaceFromInventory(inv, retrievingStack, slot, dir.ordinal())) continue;
                ItemStack ret = stack.m_41620_(1);
                if (stack.m_41613_() == 0) {
                    inv.m_6836_(slot, ItemStack.f_41583_);
                }
                tile.m_6596_();
                return ret;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, Direction direction, boolean simulate) {
        return IOHelper.insert(tile, itemStack, direction, IPneumaticTube.TubeColor.NONE, simulate);
    }

    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, Direction direction, IPneumaticTube.TubeColor color, boolean simulate) {
        if (tile == null || itemStack.m_41619_()) {
            return itemStack;
        }
        return itemStack;
    }

    public static ItemStack insert(Container inventory, ItemStack itemStack, int side, boolean simulate) {
        if (inventory instanceof WorldlyContainer && side > -1) {
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            int[] aint = isidedinventory.m_7071_(Direction.m_122376_((int)side));
            for (int j = 0; j < aint.length && !itemStack.m_41619_() && itemStack.m_41613_() > 0; ++j) {
                itemStack = IOHelper.insert(inventory, itemStack, aint[j], side, simulate);
            }
        } else {
            int k = inventory.m_6643_();
            for (int l = 0; l < k && !itemStack.m_41619_() && itemStack.m_41613_() > 0; ++l) {
                itemStack = IOHelper.insert(inventory, itemStack, l, side, simulate);
            }
        }
        if (!itemStack.m_41619_() && itemStack.m_41613_() == 0) {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    public static ItemStack insert(Container inventory, ItemStack itemStack, int slot, int side, boolean simulate) {
        ItemStack itemstack1 = inventory.m_8020_(slot);
        if (IOHelper.canPlaceItemThroughFaceToInventory(inventory, itemStack, slot, side)) {
            int max;
            boolean flag = false;
            if (itemstack1.m_41619_()) {
                int max2 = Math.min(itemStack.m_41741_(), inventory.m_6893_());
                if (max2 >= itemStack.m_41613_()) {
                    if (!simulate) {
                        inventory.m_6836_(slot, itemStack);
                        flag = true;
                    }
                    itemStack = ItemStack.f_41583_;
                } else if (!simulate) {
                    inventory.m_6836_(slot, itemStack.m_41620_(max2));
                    flag = true;
                } else {
                    itemStack.m_41620_(max2);
                }
            } else if (ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) && (max = Math.min(itemStack.m_41741_(), inventory.m_6893_())) > itemstack1.m_41613_()) {
                int l = Math.min(itemStack.m_41613_(), max - itemstack1.m_41613_());
                itemStack.m_41764_(itemStack.m_41613_() - l);
                if (!simulate) {
                    itemstack1.m_41764_(itemstack1.m_41613_() + l);
                    boolean bl = flag = l > 0;
                }
            }
            if (flag) {
                inventory.m_6596_();
            }
        }
        return itemStack;
    }

    public static boolean canPlaceItemThroughFaceToInventory(Container inventory, ItemStack itemStack, int slot, int side) {
        return inventory.m_7013_(slot, itemStack) && (!(inventory instanceof WorldlyContainer) || ((WorldlyContainer)inventory).m_7155_(slot, itemStack, Direction.m_122376_((int)side)));
    }

    public static boolean canTakeItemThroughFaceFromInventory(Container inventory, ItemStack itemStack, int slot, int side) {
        return !(inventory instanceof WorldlyContainer) || ((WorldlyContainer)inventory).m_7157_(slot, itemStack, Direction.m_122376_((int)side));
    }

    public static void dropInventory(Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof Container)) {
            return;
        }
        Container inventory = (Container)tileEntity;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
            IOHelper.spawnItemInWorld(world, itemStack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public static void spawnItemInWorld(Level world, ItemStack itemStack, BlockPos pos) {
        IOHelper.spawnItemInWorld(world, itemStack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void spawnItemInWorld(Level world, ItemStack itemStack, double x, double y, double z) {
        if (world.f_46443_) {
            return;
        }
        float dX = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        float dY = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        float dZ = world.f_46441_.m_188501_() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack((ItemLike)itemStack.m_41720_(), itemStack.m_41613_()));
        if (itemStack.m_41782_()) {
            entityItem.m_32055_().m_41751_(itemStack.m_41783_().m_6426_());
        }
        float factor = 0.05f;
        entityItem.m_20334_(world.f_46441_.m_188583_() * (double)factor, world.f_46441_.m_188583_() * (double)factor + (double)0.2f, world.f_46441_.m_188583_() * (double)factor);
        world.m_7967_((Entity)entityItem);
        itemStack.m_41764_(0);
    }

    public static boolean canInterfaceWith(BlockEntity tile, Direction direction) {
        return IOHelper.canInterfaceWith(tile, direction, true);
    }

    public static boolean canInterfaceWith(BlockEntity tile, Direction direction, boolean canInterfaceWithContainer) {
        if (!canInterfaceWithContainer) {
            return false;
        }
        if (tile instanceof ITubeConnection) {
            return true;
        }
        if (tile instanceof Container) {
            return !(tile instanceof WorldlyContainer) || ((WorldlyContainer)tile).m_7071_(direction).length > 0;
        }
        return false;
    }
}

