/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.event;

import com.bluepowermod.BluePower;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import com.bluepowermod.util.ItemStackUtils;
import com.bluepowermod.world.WorldGenVolcano;
import com.google.gson.JsonElement;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;

public class BPRecyclingReloadListener
extends SimplePreparableReloadListener<Void> {
    private final ReloadableServerResources serverResources;

    public BPRecyclingReloadListener(ReloadableServerResources serverResources) {
        this.serverResources = serverResources;
    }

    protected void apply(Void pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        BPRecyclingReloadListener.onResourceManagerReload(this.serverResources.m_206887_().m_44013_(RecipeType.f_44107_));
        WorldGenVolcano.updateAlterBlocks();
    }

    public static void onResourceManagerReload(List<CraftingRecipe> recipeList) {
        String[] blacklistStr;
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        AlloyFurnaceRegistry.getInstance().blacklist.clear();
        for (String configString : blacklistStr = ((String)BPConfig.CONFIG.alloyFurnaceBlacklist.get()).split(",")) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configString));
            if (item == null) continue;
            AlloyFurnaceRegistry.getInstance().blacklist.add(item);
        }
        AlloyFurnaceRegistry.getInstance().recyclingRecipes.clear();
        List<ItemStack> recyclingItems = AlloyFurnaceRegistry.getInstance().recyclingItems;
        for (ItemStack outputItem : recyclingItems) {
            HashSet<Item> blacklist = new HashSet<Item>(AlloyFurnaceRegistry.getInstance().blacklist);
            for (CraftingRecipe recipe : recipeList) {
                NonNullList ingredients = null;
                try {
                    ingredients = recipe.m_7527_();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (ingredients == null || recipe.m_5598_()) continue;
                int recyclingAmount = 0;
                ItemStack currentlyRecycledInto = ItemStack.f_41583_;
                try {
                    if (!ingredients.isEmpty()) {
                        for (Ingredient input : ingredients) {
                            Ingredient ingredient;
                            if (input.m_43947_() || !(ingredient = Ingredient.m_43917_((JsonElement)input.m_43942_())).test(outputItem)) continue;
                            ItemStack moltenDownItem = AlloyFurnaceRegistry.getInstance().getRecyclingStack(outputItem);
                            if (!currentlyRecycledInto.m_41619_() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue;
                            currentlyRecycledInto = moltenDownItem;
                            recyclingAmount += moltenDownItem.m_41613_();
                        }
                    }
                }
                catch (Throwable e) {
                    BluePower.log.error("Error when generating an Alloy Furnace recipe for item " + outputItem.m_41611_().getString() + ", recipe output: " + recipe.m_8043_().m_41611_().getString());
                    e.printStackTrace();
                }
                if (recyclingAmount <= 0 || recipe.m_8043_().m_41613_() <= 0) continue;
                if (!blacklist.contains(recipe.m_8043_().m_41720_()) && recipe.m_8043_().m_41613_() > recyclingAmount) {
                    blacklist.add(recipe.m_8043_().m_41720_());
                }
                if (blacklist.contains(recipe.m_8043_().m_41720_())) continue;
                ItemStack output = new ItemStack((ItemLike)currentlyRecycledInto.m_41720_(), Math.min(64, recyclingAmount / recipe.m_8043_().m_41613_()));
                AlloyFurnaceRegistry.getInstance().recyclingRecipes.put(recipe.m_8043_().m_41720_(), output);
            }
        }
    }

    protected Void prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return null;
    }
}

