/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.BPMenuType;
import com.bluepowermod.client.gui.GuiContainerBase;
import com.bluepowermod.container.slot.SlotPhantom;
import com.bluepowermod.tile.tier2.TileSortingMachine;
import java.util.Arrays;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerSortingMachine
extends AbstractContainerMenu {
    private final Container inventory;
    public TileSortingMachine.PullMode pullMode = TileSortingMachine.PullMode.AUTOMATIC;
    public TileSortingMachine.SortMode sortMode = TileSortingMachine.SortMode.ANY_ITEM;
    public int curColumn = -1;
    public final IPneumaticTube.TubeColor[] colors = new IPneumaticTube.TubeColor[9];
    public final int[] fuzzySettings = new int[8];

    public ContainerSortingMachine(int windowId, Inventory invPlayer, Container inventory) {
        super((MenuType)BPMenuType.SORTING_MACHINE.get(), windowId);
        this.inventory = inventory;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.m_38897_(new SlotPhantom(this.inventory, i * 8 + j, 26 + j * 18, 18 + i * 18));
            }
        }
        this.bindPlayerInventory(invPlayer);
        Arrays.fill(this.fuzzySettings, -1);
    }

    public ContainerSortingMachine(int windowId, Inventory invPlayer) {
        this(windowId, invPlayer, (Container)new SimpleContainer(40));
    }

    protected void bindPlayerInventory(Inventory invPlayer) {
        int offset = 157;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, offset + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)invPlayer, j, 8 + j * 18, 58 + offset));
        }
    }

    public ItemStack m_7648_(Player player, int par2) {
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7511_(int id, int value) {
        if (id < 9) {
            this.colors[id] = IPneumaticTube.TubeColor.values()[value];
            ((GuiContainerBase)ClientProxy.getOpenedGui()).redraw();
        }
        if (id == 9) {
            this.pullMode = TileSortingMachine.PullMode.values()[value];
            ((GuiContainerBase)ClientProxy.getOpenedGui()).redraw();
        }
        if (id == 10) {
            this.sortMode = TileSortingMachine.SortMode.values()[value];
            ((GuiContainerBase)ClientProxy.getOpenedGui()).redraw();
        }
        if (id == 11) {
            this.curColumn = value;
        }
        if (id >= 12 && id < 21) {
            this.fuzzySettings[id - 12] = value;
            ((GuiContainerBase)ClientProxy.getOpenedGui()).redraw();
        }
    }

    public boolean m_6875_(Player entityplayer) {
        return this.inventory.m_6542_(entityplayer);
    }
}

